<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:saxon="http://icl.com/saxon"
xsl:extension-element-prefixes="saxon">

<xsl:strip-space elements="*"/>

<xsl:variable name="counter" select="0" saxon:assignable="yes"/>

<xsl:output method="html" omit-xml-declaration="yes" indent="no"/>

<xsl:template match="/">
<html>
  <head>
    <link rel="stylesheet" href="theory_style.css" />
  </head>
  
  <body>
    <xsl:for-each select="main">
       <xsl:apply-templates  select="frontpage"/>
       <br/>
       <xsl:apply-templates  select="theory"/> 
       <br/>
      <xsl:for-each select="chapter">
	<xsl:apply-templates  select="."/>
      </xsl:for-each>
    </xsl:for-each>
  </body>
</html>
</xsl:template>

<xsl:template match="frontpage">
   <xsl:apply-templates />   
</xsl:template>

<xsl:template match="title">    
  <h1>
    <xsl:apply-templates />   
  </h1>
  <br/>
</xsl:template>

<xsl:template match="authors">
  <h1 style="font-size:80%;">
    <span class="author">
      <xsl:apply-templates />   
    </span>
  </h1>
  <br/>
</xsl:template>

<xsl:template match="formalizedby">
  <p class ="formalizedby">
    <xsl:text>Formalized by: </xsl:text>
    <span class="author">
    <xsl:for-each select = "name">
      <xsl:value-of select= "."/>
      <xsl:if test="position()!=last()">
	<xsl:text>, </xsl:text>
      </xsl:if>
    </xsl:for-each>
    </span>
  </p>
</xsl:template>

<xsl:template match="provedby">    
  <xsl:text>Proved by: </xsl:text>
  <span class="author">
    <xsl:apply-templates />   
  </span>
  <br/>
</xsl:template>

<xsl:template match="date">    
  <xsl:text>Date: </xsl:text>
  <xsl:apply-templates />   
  <br/>
</xsl:template>


<xsl:template match="chapter">    
  <h2>
    <xsl:text>Chapter </xsl:text>
    <xsl:value-of select="@name"/>
    <xsl:text>:</xsl:text>
  </h2>
  <br/>
  <br/>
  <xsl:apply-templates/>
<!--
  <xsl:for-each select="theorem">
    <xsl:apply-templates select="."/>
  </xsl:for-each>
-->

</xsl:template>


<xsl:template match="theory">
  <h2>
    <xsl:text>Theory description:</xsl:text>
  </h2>
  <br/>
  <h3>
    <xsl:text>Signature</xsl:text>
  </h3>
  <br/>
  <h4>
    <xsl:text>Types:</xsl:text>   
  </h4>
  <br/>
  <xsl:apply-templates  select="signature"/>  
  <br/>
  <h3>
    <xsl:text>Axioms</xsl:text>
  </h3>
  <br/>
  <br/>
  <xsl:apply-templates  select="axiom"/>
  <br/>
</xsl:template>

<xsl:template match="signature">
  <xsl:apply-templates  select="type"/>  
<!-- hide relations
   <h4>
    <xsl:text>Relations:</xsl:text>  
  </h4>
  <xsl:apply-templates  select="relation_symbol"/> 
  <xsl:apply-templates  select="constant"/>  -->
</xsl:template>

<xsl:template match="type">
  <xsl:apply-templates/>
  <br/> 
</xsl:template>

<xsl:template match="relation_symbol">
  
  <xsl:value-of select="@name"/>
  <xsl:text> : </xsl:text>
  <xsl:for-each select="type">
    <xsl:value-of select="."/>
    <xsl:text> &#8594; </xsl:text>
  </xsl:for-each>
  <xsl:text>Prop.</xsl:text>
  <br/>
</xsl:template>

<xsl:template match="axiom">
  <span class="keyword">
    <xsl:text>Axiom </xsl:text>   
  </span>
  <xsl:value-of select="@name"/>
  <xsl:text> : </xsl:text> 
  <br/>
  <div class="statement">
    <xsl:apply-templates />  
  </div>
  <br/>  
</xsl:template>

<xsl:template match="conjecture">
  <span class="keyword">
    <xsl:text>Theorem </xsl:text> 
  </span>
  <span class="theorem_name">
    <xsl:value-of select = "name"/> 
  </span>
  <xsl:text>.</xsl:text> 
  <br/>
  <div class="statement">
    <xsl:apply-templates select = "cl_formula"/> 
  </div>
  <br/>
<!--
  <xsl:if test = "proof">
    <xsl:text>Proof:</xsl:text>  
    <br/>
  </xsl:if>
  <p class="proof">
    <xsl:apply-templates select = "proof"/>  
  </p>
  <xsl:if test = "proof">
    <xsl:text>Qed.</xsl:text>
    <br/>
  </xsl:if>
-->
  <br/>
</xsl:template>

<xsl:template match="theorem">
  <span class="keyword">
    <xsl:text>Theorem </xsl:text> 
  </span>
  <span class="theorem_name">
    <xsl:value-of select = "theorem_name"/> 
  </span>
  <xsl:text>.</xsl:text> 
  <br/>
  <div class="statement">
    <xsl:apply-templates select = "cl_formula"/> 
  </div>
  <br/>
  <xsl:if test = "proof">
    <xsl:text>Proof:</xsl:text>  
    <br/>
  </xsl:if>
  <p class="proof">
    <xsl:apply-templates select = "proof"/>  
  </p>
  <xsl:if test = "proof">
    <xsl:text>Qed.</xsl:text>
    <br/>
  </xsl:if>
  <br/>
</xsl:template>


<xsl:template match="cl_formula">
   <xsl:if test = "from">
    <xsl:text>Assuming that </xsl:text>
    <xsl:for-each select = "from/conj/atom">
      <xsl:apply-templates select = "."/>
      <xsl:if test = "position()!=last()">
        <xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>
  </xsl:if>

  <xsl:apply-templates select = "have/obtain_witness"/>

  <xsl:if test = "from/conj/atom and have/variables">
    <xsl:text> there exist </xsl:text>
  </xsl:if>
  
  <xsl:if test = "not(from/conj/atom) and have/variables">
    <xsl:text>There exist </xsl:text>
  </xsl:if>

  <xsl:for-each select="have/variables/variable">
    <xsl:value-of select= "@type"/>
    <xsl:text> </xsl:text>  
    <xsl:value-of select="@name"/>
    <xsl:text>, </xsl:text>
  </xsl:for-each>
  
  <xsl:if test = "have/obtain_witness">
    <xsl:text> where </xsl:text>
  </xsl:if>

  <xsl:if test="have/variables">
    <xsl:text>such that </xsl:text>
  </xsl:if>

  <xsl:if test = "not(have/variables) and (have/dnf/conj/atom) and 
		  from">
    <xsl:text> it holds that </xsl:text>
  </xsl:if>
  
  <xsl:if test = "not(have/variables) and (have/dnf/conj/atom) and 
		  not(from)">
    <xsl:text>It holds that </xsl:text>
  </xsl:if>

  <xsl:if test = "have">

    <xsl:for-each select="have/dnf/conj">
      <xsl:for-each select="atom">
        <xsl:apply-templates select="."/>
        <xsl:if test="position()!=last()">
          <xsl:text> and </xsl:text>
        </xsl:if>
      </xsl:for-each>
      <xsl:if test= "position()!= last()">
        <xsl:text> or </xsl:text>
      </xsl:if>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test = "not(have/dnf/conj/atom)">
    <xsl:text> we have contradiction</xsl:text>
  </xsl:if>

  <xsl:text>.</xsl:text>
  <br/>
</xsl:template>

<xsl:template match="variables">
     <xsl:apply-templates />         
</xsl:template>

<xsl:template match="variable">
     <xsl:value-of select="@name"/>
</xsl:template>

<xsl:template match="witnes">
   <xsl:value-of select="."/>       
</xsl:template>

<xsl:template match="from">
    <xsl:apply-templates />         
</xsl:template>


<xsl:template match="have">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="dnf">
  <xsl:for-each select="conj">
    <xsl:text>(</xsl:text>
    <xsl:apply-templates select="." />
    <xsl:text>)</xsl:text>
    <xsl:if test="position()!=last()">
      <xsl:text> \; </xsl:text>
      <xsl:text> \vee </xsl:text>
      <xsl:text> \; </xsl:text>      
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="conj">
  <xsl:for-each select = "atom">
    <xsl:apply-templates select = "."/>
    <xsl:if test = "position()!=last()">
      <xsl:text> and </xsl:text>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:include href="layout.xsl" />

<xsl:template match="atom">
  <xsl:if test="@type = 'general'">
    <span style="font-variant:small-caps;">    
    <xsl:value-of select="relation_symbol/@name"/>
    <xsl:text>(</xsl:text>
    <xsl:for-each select="parameter">
      <xsl:value-of select = "."/>       
      <xsl:if test="position()!=last()">
	<xsl:text>, </xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:text>)</xsl:text>
    </span>
  </xsl:if>

  <xsl:if test = "@type = 'equal'">
    <xsl:value-of select="parameter[1]"/>
    <xsl:text> = </xsl:text>
    <xsl:value-of select="parameter[2]"/>
  </xsl:if>

  <xsl:if test = "@type = 'not_equal'">
    <xsl:value-of select="parameter[1]"/>
    <xsl:text>&#8800;</xsl:text>
    <xsl:value-of select="parameter[2]"/>
  </xsl:if>
</xsl:template>


<xsl:template match="theorem_name">
    <font class="name"><xsl:value-of select="."/>.</font>
</xsl:template>


<xsl:template match="proof">
  <xsl:apply-templates />         
</xsl:template>

<xsl:template match="proof_step">
   <xsl:apply-templates select = "modus_ponens"/>
</xsl:template>

<xsl:template match="proof_closing">
   
   <xsl:if test = "from">     
     <xsl:text>From the facts </xsl:text>
     <xsl:for-each select = "from/conj/atom">
       <xsl:apply-templates select = "."/>
       <xsl:if test = "position()!=last()">
	 <xsl:text> and </xsl:text>
       </xsl:if>
     </xsl:for-each>
   </xsl:if>

   <xsl:apply-templates select="efq"/>

   <xsl:if test = "case_split">
     <xsl:apply-templates select = "case_split/assumption"/>     
     <xsl:apply-templates select = "proof"/>
   </xsl:if>
     
   <xsl:if test = "goal_reached_thesis">
     <xsl:if test = "not(case_split) and not(from)">
       <xsl:text>This proves the conjecture.</xsl:text>
      </xsl:if>
     
     <xsl:if test = "not(case_split) and (from)">
       <xsl:text> we proved a conjecture.</xsl:text>
       <br/>
     </xsl:if>
   </xsl:if>


</xsl:template>

<xsl:template match="modus_ponens">

  <xsl:if test="from">
    <xsl:text>From the facts </xsl:text>
    <xsl:for-each select = "from/conj/atom">
      <xsl:apply-templates select = "."/>
      <xsl:if test = "position()!=last()">
	<xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>
    
  </xsl:if>

  <xsl:if test="have/obtain_witness">

    <xsl:if test="from">
      <xsl:text> there exist </xsl:text>
    </xsl:if>
    <xsl:if test="not(from)">
      <xsl:text>There exist </xsl:text>
    </xsl:if>

    <xsl:for-each select="have/obtain_witness/constant">
      <xsl:text>a </xsl:text>
      <xsl:value-of select="@type"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="@name"/>
      
      <xsl:if test="position()!=last()">
	<xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>  
    
    <xsl:text> where </xsl:text>
  </xsl:if>

  <xsl:if test = "not(have/obtain_witness) and have/dnf/conj/atom and from">
    <xsl:text> it holds that </xsl:text>
  </xsl:if>

  <xsl:if test = "not(have/obtain_witness) and have/dnf/conj/atom and 
		  not(from)">
    <xsl:text>It holds that </xsl:text>
  </xsl:if>

  <xsl:if test = "have">

    <xsl:for-each select="have/dnf/conj">                                    
      <xsl:for-each select="atom">
        <xsl:apply-templates select="."/>
        <xsl:if test="position()!=last()"> 
          <xsl:text> and </xsl:text> 
        </xsl:if>                                                           
      </xsl:for-each>                                      
      <xsl:if test= "position()!= last()">
        <xsl:text> or </xsl:text> 
      </xsl:if>                                                        
    </xsl:for-each> 
  </xsl:if>

  <xsl:if test = "not(have/dnf/conj/atom)">
    <xsl:text> we get contradiction</xsl:text>
  </xsl:if>

  <xsl:if test = "@axiom_name">      
    <xsl:text> (using </xsl:text>
    <xsl:value-of select = "@axiom_name"/>
    <xsl:text>)</xsl:text>
  </xsl:if>
  <xsl:text>.</xsl:text>
  <br/>
</xsl:template>

<xsl:template match="case_split">
  <xsl:text>Proof cases:</xsl:text>
  
  <saxon:assign name="counter" select="$counter+1"/> 
  <xsl:value-of select="$counter"/> 
  <xsl:apply-templates />         
</xsl:template>

<xsl:template match="assumption">
   <xsl:text>Assume that: </xsl:text>
   <xsl:apply-templates  select="conj"/> 
   <xsl:text> </xsl:text>
     
   <xsl:apply-templates  select="proof"/> 
   
</xsl:template>

<xsl:template match="disjunction_elimination">
    <xsl:text>The conjecture was proved in all cases: </xsl:text>
    <xsl:text> </xsl:text>
    
    <xsl:for-each select="dnf/conj">
      <xsl:text> (</xsl:text>
      <xsl:for-each select = "atom">
	<xsl:apply-templates select = "."/>
	<xsl:if test = "position()!=last()">
	  <xsl:text> \wedge </xsl:text> 
	</xsl:if>
      </xsl:for-each>
      <xsl:text>)</xsl:text>
      
      <xsl:if test="position()!=last()">
	<xsl:text> \; </xsl:text>
	<xsl:text> \vee </xsl:text>
	<xsl:text> \; </xsl:text>
	
      </xsl:if>
    </xsl:for-each>
    <xsl:text> </xsl:text>
</xsl:template>

</xsl:stylesheet>
