<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:saxon="http://icl.com/saxon"
xsl:extension-element-prefixes="saxon">

<xsl:strip-space elements="*"/>

<xsl:output method="text" omit-xml-declaration="yes" indent="no"/>

<xsl:template match="/">
<html>
    <head>
        <style> 
	  <!--            font.name       {font: italic;}         -->
        </style>
    </head>

    <body>
    <xsl:for-each select="main">
           
	<xsl:text>theory </xsl:text>
	<xsl:value-of select="theory/theory_name"/>
	<xsl:text>&#xA;</xsl:text>

	<xsl:text>imports Main &#xA;</xsl:text> 
	<xsl:text>begin&#xA;</xsl:text> 

	<xsl:apply-templates select="theory/signature"/>
           
        <hr/>
           
	<xsl:if test="theory/axiom">
	  <xsl:text>&#xA;&#xA;axiomatization where &#xA;&#xA;</xsl:text>
	</xsl:if>
        <xsl:apply-templates  select="theory/axiom"/>

	<xsl:for-each select="chapter">
	  <xsl:apply-templates select="."/>
	</xsl:for-each>
	
	<xsl:text>end&#xA;&#xA;</xsl:text>   
        <hr/>
        <font color="#0000ff">
        <xsl:text>(*Transformed by Vernacular package (2013)*)</xsl:text>
        </font>
   </xsl:for-each>

    </body>
</html>
</xsl:template>

<xsl:template match="signature">
  <xsl:for-each select = "type">
    <xsl:text>typedecl </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xA;&#xA;</xsl:text>
  </xsl:for-each>

  <xsl:apply-templates select="relation_symbol"/>
</xsl:template>

<xsl:template match="chapter">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match = "proof_name">
  <!--<xsl:value-of select="@name"/>-->
</xsl:template>

<xsl:template match="relation_symbol">
	<xsl:text>&#xA;consts </xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text> :: </xsl:text>
	
	<xsl:text> "</xsl:text>
	<xsl:for-each select="type">
	  <xsl:value-of select="."/>
	  <xsl:text> \&lt;Rightarrow&gt; </xsl:text>
	</xsl:for-each>
	<xsl:text> bool </xsl:text>
	<xsl:text>"</xsl:text>
</xsl:template>

<xsl:template match="attributes">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="attribute">
	<xsl:value-of select="@type"/>
	<xsl:text> \&lt;Rightarrow&gt; </xsl:text>
</xsl:template>

<xsl:template match="axiom">
  <xsl:value-of select="@name"/>
  <xsl:text>: </xsl:text> 
  
  <xsl:text>"</xsl:text>
  <xsl:apply-templates  select="cl_formula/from"/>    
  
  <xsl:if test="cl_formula/from">  
    <xsl:text> \&lt;Longrightarrow&gt; </xsl:text> 
  </xsl:if>

  <xsl:if test="cl_formula/have">
    <xsl:if test="cl_formula/have/variables">
      <xsl:text>\&lt;exists&gt;</xsl:text>
      <xsl:for-each select="cl_formula/have/variables/variable">
	<xsl:text>(</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>::</xsl:text>
	<xsl:value-of select="@type"/>
	<xsl:text>)</xsl:text>
      </xsl:for-each>
      <xsl:text>.</xsl:text>
    </xsl:if>

    <xsl:apply-templates  select="cl_formula/have/dnf"/>
      
    
  </xsl:if>
  
  <xsl:text>"</xsl:text>
  
  <xsl:if test="position()!=last()">
    <xsl:text>&#xA;and </xsl:text>
  </xsl:if>
  
  
</xsl:template>


<xsl:template match="atom">

  <xsl:if test="@type = 'general'">
    <xsl:value-of select="relation_symbol/@name"/>
    <xsl:for-each select="parameter">
      <xsl:text> </xsl:text>
      <xsl:apply-templates/>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test="@type = 'equal'">
    <xsl:value-of select="parameter[1]"/>
    <xsl:text> = </xsl:text>
    <xsl:value-of select="parameter[2]"/>
  </xsl:if>

  <xsl:if test="@type = 'not_equal'">
    <xsl:value-of select="parameter[1]"/>
    <xsl:text> ~= </xsl:text>
    <xsl:value-of select="parameter[2]"/>
  </xsl:if>

</xsl:template>

<xsl:template match="theorem">
  
  <xsl:apply-templates select="theorem_name"/>

  <xsl:if test="cl_formula/from">
     <xsl:text> assumes </xsl:text>
  </xsl:if>

  <xsl:for-each select="cl_formula/from/conj/atom">
    <xsl:text> "</xsl:text>
    
    <xsl:apply-templates select="."/>
    <xsl:text>" </xsl:text>
    <xsl:if test="position()!=last()">
	<xsl:text>and</xsl:text>
    </xsl:if>  

  </xsl:for-each>
  <xsl:text> shows "</xsl:text>

  <xsl:if test="cl_formula/have/variables">
    <xsl:text>\&lt;exists&gt;</xsl:text>
    <xsl:for-each select="cl_formula/have/variables/variable">
      <xsl:text>(</xsl:text>
      <xsl:value-of select="@name"/>
      <xsl:text>::</xsl:text>
      <xsl:value-of select="@type"/>
      <xsl:text>)</xsl:text>
    </xsl:for-each>
    <xsl:text>.</xsl:text>
    
  </xsl:if>

  <xsl:apply-templates select="cl_formula/have/dnf"/>
  <xsl:text>" </xsl:text> 
  

  <xsl:text>&#xA;&#xA;proof - &#xA;</xsl:text>
  <xsl:apply-templates  select="proof"/>

  <xsl:text>&#xA;&#xA;from this </xsl:text>
  <xsl:text>&#xA;show ?thesis </xsl:text>
  <xsl:text>&#xA;by auto</xsl:text>
  <xsl:text>&#xA;qed&#xA;&#xA;</xsl:text>
				 
</xsl:template>


<xsl:template match="conjecture">

  <xsl:apply-templates select="name"/>
  
  <xsl:if test="cl_formula/from">
     <xsl:text> assumes </xsl:text>
  </xsl:if>

  <xsl:for-each select="cl_formula/from/conj/atom">
    <xsl:text> "</xsl:text>
    
    <xsl:apply-templates select="."/>
    <xsl:text>" </xsl:text>
    <xsl:if test="position()!=last()">
	<xsl:text>and</xsl:text>
    </xsl:if>  

  </xsl:for-each>
  <xsl:text> shows "</xsl:text>

  <xsl:if test="cl_formula/have/variables">
    <xsl:text>\&lt;exists&gt;</xsl:text>
    <xsl:for-each select="cl_formula/have/variables/variable">
      <xsl:text>(</xsl:text>
      <xsl:value-of select="@name"/>
      <xsl:text>::</xsl:text>
      <xsl:value-of select="@type"/>
      <xsl:text>)</xsl:text>
    </xsl:for-each>
    <xsl:text>.</xsl:text>
    
  </xsl:if>

  <xsl:apply-templates select="cl_formula/have/dnf"/>
  <xsl:text>" </xsl:text> 

  <xsl:text>&#xA;sorry &#xA;</xsl:text>

   
</xsl:template>

<xsl:template match="theorem_name">
  
  <xsl:text>&#xA;&#xA;lemma </xsl:text>
  <xsl:value-of select="."/>
  <xsl:text> : </xsl:text>
  
</xsl:template>

<xsl:template match="name">
  
  <xsl:text>&#xA;&#xA;lemma </xsl:text>
  <xsl:value-of select="."/>
  <xsl:text> : </xsl:text>
  
</xsl:template>



<xsl:template match="cl_formula">
  <xsl:text>"</xsl:text>
  <xsl:apply-templates  select="from"/>    

  <xsl:if test="from">  
    <xsl:text> \&lt;Longrightarrow&gt; </xsl:text> 
  </xsl:if>


  <xsl:if test="have">
    <xsl:apply-templates  select="have"/> 
  </xsl:if>

  <xsl:text>"</xsl:text>
</xsl:template>

<xsl:template match="variables">
     <xsl:apply-templates />         
</xsl:template>

<xsl:template match="variable">
     <xsl:text>"</xsl:text>
     <xsl:value-of select="@name"/>
     <xsl:text>" </xsl:text>
</xsl:template>

<xsl:template match="from">
  <xsl:text>\&lt;lbrakk&gt;</xsl:text> 

  <xsl:for-each select="conj/atom">    
    <xsl:apply-templates select="." />
    <xsl:if test="position()!=last()">
      <xsl:text>; </xsl:text>
    </xsl:if>
  </xsl:for-each>


  <xsl:text>\&lt;rbrakk&gt;</xsl:text> 

</xsl:template>


<xsl:template match="dnf">

  <xsl:for-each select="conj">
    <xsl:text>(</xsl:text>
    <xsl:apply-templates select="." />
      
    <xsl:if test="not(atom)">
      <xsl:text>False</xsl:text>
    </xsl:if>
    
    <xsl:text>)</xsl:text>
  
    <xsl:if test="position()!=last()">
      <xsl:text>\&lt;or&gt;</xsl:text>
    </xsl:if>
  </xsl:for-each>

</xsl:template>

<xsl:template match="conj">

  <xsl:for-each select="atom">
    
    <xsl:apply-templates select="." />
    <xsl:if test="position()!=last()">
      <xsl:text> \&lt;and&gt; </xsl:text>
  
    </xsl:if>
  </xsl:for-each>
  
</xsl:template>

<xsl:template match="proof">
      <xsl:apply-templates />         
</xsl:template>


<xsl:template match="proof_step">

  <xsl:apply-templates select="modus_ponens"/>  
  
</xsl:template>


<xsl:template match="proof_closing">

  <xsl:if test = "from">
    <xsl:text>&#xA;&#xA;from </xsl:text>
    
    <xsl:for-each select="from/conj/atom">
      <xsl:text>`</xsl:text>
      <xsl:apply-templates select="."/>
      <xsl:text>`</xsl:text>
      <xsl:if test="position()!=last()">
        <xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>
    
  </xsl:if>

  <xsl:if test = "not(case_split) and not(from)">
    <xsl:text>&#xA;&#xA;from this</xsl:text>
  </xsl:if>

  <xsl:apply-templates select="efq"/>

  <xsl:apply-templates select="case_split"/>

  <xsl:if test="goal_reached_thesis">
    
    <xsl:if test="not(case_split) and not(from)">
      <xsl:text>&#xA;&#xA;from this </xsl:text>       
    </xsl:if>

    <xsl:text>&#xA;have ?thesis </xsl:text>
    <xsl:text>&#xA;by auto </xsl:text>
  </xsl:if>
  
  <xsl:if test="goal_reached_contradiction and not(modus_ponens/@axiom_name)">
    <xsl:text>&#xA;have False </xsl:text>
    <xsl:text>&#xA;by auto </xsl:text>
  </xsl:if>  
</xsl:template>


<xsl:template match="modus_ponens">
  
  <xsl:if test="from">
    <xsl:text>&#xA;&#xA;from </xsl:text>
    <xsl:for-each select="from/conj/atom">
      <xsl:text>`</xsl:text>
      <xsl:apply-templates select="."/>
      <xsl:text>`</xsl:text>
      <xsl:if test="position()!=last()">
	<xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>
    
  </xsl:if>

  <xsl:if test = "have/obtain_witness">
    <xsl:text>&#xA;&#xA;obtain </xsl:text>
    <xsl:for-each select="have/obtain_witness/constant">
      <xsl:value-of select="@name"/>
      <xsl:text>::</xsl:text>
      <xsl:value-of select="@type"/>

      <xsl:if test="position()!=last()">
	<xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>

    <xsl:text>&#xA;where </xsl:text>
  </xsl:if>
  
  <xsl:if test="not(from)">
    <xsl:text>&#xA;</xsl:text>
  </xsl:if>

  <xsl:if test = "not(have/obtain_witness) and have">
    <xsl:text>&#xA;have </xsl:text>
  </xsl:if>

  <xsl:if test = "have"> 
    <xsl:text>"</xsl:text>

    <xsl:for-each select="have/dnf/conj">

      <xsl:if test="atom">	
	<xsl:for-each select="atom">
	  <xsl:apply-templates select="."/>
	  <xsl:if test="position()!=last()">
	    <xsl:text>" and "</xsl:text>
	  </xsl:if>
	</xsl:for-each>
	
	<xsl:if test= "position()!= last()">
	  <xsl:text> \&lt;or&gt; </xsl:text>
	</xsl:if>
      </xsl:if>

      <xsl:if test="not(atom)">
	<xsl:text>False</xsl:text>
      </xsl:if>

    </xsl:for-each>
    <xsl:text>"</xsl:text>
        
  </xsl:if>
  
  <xsl:if test = "have/dnf/conj/atom">
    <xsl:if test = "@axiom_name">

      <xsl:choose>

	<xsl:when test = "have/obtain_witness or 
			  count(have/dnf/conj/atom) &gt;1">
	  <xsl:text>&#xA;using </xsl:text>
	  <xsl:value-of select="@axiom_name"/>
	  
	  <xsl:if test="constants">
	    <xsl:text> [of </xsl:text>
	    <xsl:for-each select="constants/constant">
	      <xsl:text>"</xsl:text>
	      <xsl:value-of select="@name"/>
	      <xsl:text>" </xsl:text>
	    </xsl:for-each>
	    <xsl:text>] </xsl:text>
	  </xsl:if>
	  <xsl:text>&#xA;by auto </xsl:text> 
	</xsl:when>
	
	<xsl:otherwise>
	  <xsl:text>&#xA;by (rule </xsl:text>
	  <xsl:value-of select="@axiom_name"/>
	  <xsl:text>)</xsl:text>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:if>

    <xsl:if test = "not(@axiom_name)">
      <xsl:text>&#xA;by simp</xsl:text> 
    </xsl:if>
        
  </xsl:if>

  <xsl:if test = "not(have/dnf/conj/atom) and @axiom_name">
    
    <xsl:text>&#xA;using </xsl:text>
    <xsl:value-of select="@axiom_name"/>
    <xsl:text>&#xA;by auto </xsl:text> 
  </xsl:if>
  
  <xsl:if test = "not(have/dnf/conj/atom) and not(@axiom_name)">
    <xsl:text>&#xA;by simp </xsl:text>
  </xsl:if>
  
  

</xsl:template>

<xsl:template match="have">
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="case_split">
    <xsl:text></xsl:text>
	<xsl:apply-templates />         
</xsl:template>


<xsl:template match="assumption">
    <xsl:text>&#xA;&#xA;{assume </xsl:text>
    <xsl:text> "</xsl:text>
    <xsl:apply-templates  select="conj"/>
    <xsl:text>" </xsl:text> 
      

    <xsl:apply-templates  select="proof"/> 

    <xsl:text>&#xA;} note </xsl:text>
    <xsl:value-of select="proof/proof_name/@name"/>
    <xsl:text> = this </xsl:text>
    
</xsl:template>

<xsl:template match="disjunction_elimination">
    <xsl:text>&#xA;&#xA;from </xsl:text>
    
    <xsl:for-each select="proof_names/proof_name">
      <xsl:value-of select="@name"/>
      <xsl:text> and </xsl:text>
    </xsl:for-each>

    <xsl:text>`</xsl:text>
    <xsl:apply-templates select="dnf"/>
    <xsl:text>`</xsl:text>
    
</xsl:template>
</xsl:stylesheet>
