<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:strip-space elements="*"/>

<xsl:template match="atom">

  <xsl:choose>

    <xsl:when test = "@type = 'equal'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> = </xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>
    
    <xsl:when test = "@type = 'not_equal'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \neq </xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'cong'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text> \cong </xsl:text>
      <xsl:value-of select="parameter[3]"/>
      <xsl:value-of select="parameter[4]"/>
    </xsl:when>

    <xsl:otherwise>
      <!--<xsl:if test="@type = 'general'">-->
      <xsl:value-of select="relation_symbol/@name"/>
      <xsl:text>(</xsl:text>
      <xsl:for-each select="parameter">
	<xsl:value-of select = "."/>       
	<xsl:if test="position()!=last()">
	  <xsl:text>, </xsl:text>
	</xsl:if>
      </xsl:for-each>
      <xsl:text>)</xsl:text>
    </xsl:otherwise>
    
  </xsl:choose>

</xsl:template>


</xsl:stylesheet>
