#!/bin/bash
#argumenti ulazni folder i broj razmotavanja

for filename in Output/*; do
    rm $filename
done

for filename in $1/*.cpp; do
    F="${filename##*/}"
    echo $filename
    clang -c -g -emit-llvm -Wall -std=c++11 -stdlib=libstdc++ -I/usr/include/i386-linux-gnu/c++/4.8 $filename -o $F.o 2>/dev/null      
    K="time LAV -check-div-zero=true -solver=Z3-LA-ARR-EUF -check-pointers=true -loop-unroll-begin=$2 -loop-unroll-end=0 $F.o >izl"
    echo $K
    time LAV -check-div-zero=true -solver=Z3-LA-ARR-EUF -check-pointers=true -loop-unroll-begin=$2 -loop-unroll-end=0 $F.o >izl
    rm $F.o
    echo
done

for filename in Output/*; do
    echo $filename
    cat $filename
done




