#!/bin/bash
#argumenti ulazni folder i broj razmotavanja

for filename in Output/*; do
    rm $filename
done

for filename in $1/*.cpp; do
    F="${filename##*/}"
    if [[ "$F" = "main.cpp" ]]; then 
    continue 
    fi
    if [[ "$F" = "zbir.cpp" ]]; then 
    continue 
    fi
    echo $filename
    clang -c -g -emit-llvm -Wall -std=c++11 -stdlib=libstdc++ -I/usr/include/i386-linux-gnu/c++/4.8 $filename -o $F.o 2>/dev/null      
    timeout 300 time LAV -check-div-zero=false -solver=Boolector-BV-ARR-ACK -check-pointers=false -skip-inside-loop=false -loop-unroll-begin=$2 -loop-unroll-end=0 $F.o >izl
    K="time LAV -check-div-zero=false -solver=Boolector-BV-ARR-ACK -check-pointers=false -loop-unroll-begin=$2 -loop-unroll-end=0 $F.o >izl"
    echo $K
    rm $F.o
    echo
done

for filename in Output/*; do
    echo $filename
    cat $filename
done




