int linearSearch(int a[], int n, int x) {
  for (int i = 0; i < n; i++)
    if (a[i] == x)
      return i;
  return -1;
}

int binarySearchRec_(int a[], int l, int r, int x) {
  if (l > r) return -1;
  int s = l + (r - l) / 2;
  if (x < a[s])
    return binarySearchRec_(a, l, s-1, x);
  if (x > a[s])
    return binarySearchRec_(a, s+1, r, x);
  return s;
}

int binarySearchRec(int a[], int n, int x) {
  return binarySearchRec_(a, 0, n-1, x);
}

int binarySearchEq(int a[], int n, int x) {
  int l = 0, r = n-1;
  while (l <= r) {
    int s = l + (r - l) / 2;
    if (x < a[s])
      r = s-1;
    else if (x > a[s])
      l = s+1;
    else
      return s;
  }
  return -1;
}

int binarySearchGeq1(int a[], int n, int x) {
  int l = 0, r = n-1;
  while (l <= r) {
    int s = l + (r - l) / 2;
    if (a[s] < x)
      l = s+1;
    else
      r = s-1;
  }
  if (l < n && a[l] == x)
    return l;
  return -1;
}

int binarySearchGeq2(int a[], int n, int x) {
  int l = 0, r = n;
  while (l < r) {
    int s = l + (r - l) / 2;
    if (a[s] < x)
      l = s+1;
    else
      r = s;
  }
  return r < n && a[r] == x ? r : -1;
}

#ifdef __TESTING__

#include <iostream>
using namespace std;

int main() {
  int a[] = {1, 3, 4, 5, 7, 9, 11, 13, 18};
  int n = sizeof(a) / sizeof(int);
  int x = 13;
  cout << linearSearch(a, n, x) << endl;
  cout << binarySearchRec(a, n, x) << endl;
  cout << binarySearchEq(a, n, x) << endl;
  cout << binarySearchGeq1(a, n, x) << endl;
  cout << binarySearchGeq2(a, n, x) << endl;
  return 0;
}

#endif
