const int maxS = 10;
const int INF = 4;

int min(int a, int b) {
  return a < b ? a : b;
}

int minCoinsRecursive(int v[], int n, int s){
  if (s == 0)
    return 0;
  int num = INF;
  for (int i = 0; i < n; i++)
    if (v[i] <= s)
      num = min(num, minCoinsRecursive(v, n, s-v[i]) + 1);
  return num;
}

int minCoinsMemo_(int v[], int n, int S, int memo[]){
  if (memo[S] != 0)
    return memo[S];
  if (S == 0)
    return memo[S] = 0;
  int br = INF;
  for (int i = 0; i < n; i++)
    if (v[i] <= S)
      br = min(br, minCoinsMemo_(v, n, S-v[i], memo) + 1);
  return memo[S] = br;
}

int minCoinsMemo(int v[], int n, int S) {
  int memo[maxS + 1];
  for (int i = 0; i <= maxS; i++)
    memo[i] = 0;
  return minCoinsMemo_(v, n, S, memo);
}

int minCoinsDP(int v[], int N, int S){
  int dp[maxS + 1];
  dp[0] = 0;
  for (int s = 1; s <= S; s++) {
    dp[s] = INF;
    for (int n = 0; n < N; n++)
      if (v[n] <= s)
	dp[s] = min(dp[s], dp[s-v[n]] + 1);
  }
  return dp[S];
}

int minCoinsRecursive1(int v[], int n, int s){
  if (s == 0)
    return 0;
  if (n == 0)
    return INF;
  int num = minCoinsRecursive1(v, n-1, s);
  if (s >= v[n-1])
    num = min(num, minCoinsRecursive1(v, n, s - v[n-1]) + 1);
  return num;
}

int minCoinsMemo1_(int v[], int n, int s, int memo[MAX][maxS + 1]){
  if (memo[n][s] != 0)
    return memo[n][s];
  if (s == 0)
    return memo[n][s] = 0;
  if (n == 0)
    return memo[n][s] = INF;
  int num = minCoinsMemo1_(v, n-1, s, memo);
  if (s >= v[n-1])
    num = min(num, minCoinsMemo1_(v, n, s - v[n-1], memo) + 1);
  return memo[n][s] = num;
}

int minCoinsMemo1(int v[], int n, int s) {
  int memo[MAX][maxS + 1];
  for (int i = 0; i < MAX; i++)
    for (int j = 0; j <= maxS; j++)
      memo[i][j] = 0;
  return minCoinsMemo1_(v, n, s, memo);
}

int minCoinsDP1(int v[], int N, int S){
  int dp[maxS + 1];
  dp[0] = 0;
  for (int s = 1; s <= S; s++)
    dp[s] = INF;

  for (int n = 1; n <= N; n++) {
    for (int s = 0; s <= S; s++) {
      if (s >= v[n-1])
	dp[s] = min(dp[s], dp[s - v[n-1]] + 1);
    }
  }

  return dp[S];
}


#ifdef __TESTING__

#include <iostream>
using namespace std;

int main() {
  int N, S;
  int v[MAX];
  cin >> S >> N;
  for (int i = 0; i < N; i++)
    cin >> v[i];
  int num = minCoinsRecursive1(v, N, S);
  cout << (num == INF ? -1 : num)  << endl;
  return 0;
}

#endif
