
int fibRecursive(int n) {
  if (n < 2)
    return n;
  return fibRecursive(n-1) + fibRecursive(n-2);
}

int fibMemo_(int n, int memo[]) {
  if (memo[n] != 0)
    return memo[n];

  if (n < 2)
    return memo[n] = n;
  
  else return memo[n] = fibMemo_(n-1, memo) + fibMemo_(n-2, memo);
}

int fibMemo(int n) {
  int memo[MAX];
  int i;
  for (i = 0; i <= n; i++)
    memo[i] = 0;
  return fibMemo_(n, memo);
}

int fibDP(int n) {
  int dp[MAX];
  dp[0] = 0;
  dp[1] = 1;
  for (int i = 2; i <= n; i++)
    dp[i] = dp[i-1] + dp[i-2];
  return dp[n];
}

int fibDPMemOptimized(int n) {
  if (n < 2)
    return n;
  
  int fpp = 0, fp = 1;
  for (int i = 2; i <= n; i++) {
    int f = fpp + fp;
    fpp = fp;
    fp = f;
  }
  return fp;
}

#ifdef __TESTING__

#include <iostream>
using namespace std;

int main() {
  for (int n = 0; n < 10; n++) {
    cout << fibRecursive(n) << " "
	 << fibMemo(n) << " "
	 << fibDP(n) << " "
	 << fibDPMemOptimized(n) << endl;
  }
  return 0;
}

#endif
