void swap(int a[], int i, int j) {
  int tmp = a[i];
  a[i] = a[j];
  a[j] = tmp;
}

int partition(int a[], int l, int r) {
  int pivot = a[l];
  int last_leq_pivot = l;
  for (int i = l+1; i <= r; i++)
    if (a[i] <= pivot)
      swap(a, i, ++last_leq_pivot);
  swap(a, l, last_leq_pivot);
  return last_leq_pivot;
}

int kthElementQuickSelect(int a[], int n, int k) {
  int l = 0, r = n-1;
  while (l <= r) {
    int pivot_pos = partition(a, l, r);
    if (k < pivot_pos)
      r = pivot_pos-1;
    else if (k > pivot_pos)
      l = pivot_pos+1;
    else
      return a[pivot_pos];
  }
  return -1;
}

void quickSort_(int a[], int l, int r) {
  if (l >= r) return;
  int pivot_pos = partition(a, l, r);
  quickSort_(a, l, pivot_pos-1);
  quickSort_(a, pivot_pos+1, r);
}

void quickSort(int a[], int n) {
  return quickSort_(a, 0, n-1);
}

int kthElementSelectionSort(int a[], int n, int k) {
  for (int i = 0; i < n; i++)
    for (int j = i+1; j<n; j++)
      if (a[i] > a[j])
	swap(a, i, j);
  return a[k];
}

int kthElementQuickSort(int a[], int n, int k) {
  quickSort(a, n);
  return a[k];
}

#ifdef __TESTING__

#include <iostream>
using namespace std;

int main() {
  int a[] = {3, 5, 8, 4, 2, 6, 7, 0, 1, 16, 13, 10};
  int n = sizeof(a) / sizeof(int);
  for (int k = 0; k < n; k++) {
    cout << kthElementSelectionSort(a, n, k) << " ";
    cout << kthElementQuickSort(a, n, k) << " ";
    cout << kthElementQuickSelect(a, n, k) << " ";
    cout << endl;
  }
}

#endif
