
void longestIncreasingSubsequenceRecursive_(int a[], int k,
					    int* max_ending_k, int* max) {
  *max_ending_k = 1;
  
  for (int i = 0; i < k; i++) {
    int max_ending_i;
    longestIncreasingSubsequenceRecursive_(a, i, &max_ending_i, max);
    if (a[i] < a[k] && *max_ending_k < max_ending_i + 1)
      *max_ending_k = max_ending_i + 1;
  }
 
  if (*max < *max_ending_k)
    *max = *max_ending_k;
}
 
int longestIncreasingSubsequenceRecursive(int a[], int n) {
  int max_ending, max = 0;
  if (n > 0)
    longestIncreasingSubsequenceRecursive_(a, n-1, &max_ending, &max);
  return max;
}



void longestIncreasingSubsequenceMemo_(int a[], int k,
				       int* max_ending_k, int* max, int memo[]) {
  if (memo[k] > 0) {
    *max_ending_k = memo[k];
    return;
  }

  *max_ending_k = 1;
  
  for (int i = 0; i < k; i++) {
    int max_ending_i;
    longestIncreasingSubsequenceMemo_(a, i, &max_ending_i, max, memo);
    if (a[i] < a[k] && *max_ending_k < max_ending_i + 1)
      *max_ending_k = max_ending_i + 1;
  }
  
  memo[k] = *max_ending_k;
  if (*max < *max_ending_k)
    *max = *max_ending_k;
}

int longestIncreasingSubsequenceMemo(int a[], int n) {
  int memo[MAX];
  for (int i = 0; i < n; i++)
    memo[i] = 0;
  int max_ending, max = 0;
  if (n > 0)
    longestIncreasingSubsequenceMemo_(a, n-1, &max_ending, &max, memo);
  return max;
}

int longestIncreasingSubsequenceDP(int a[], int n) {
  // dp[i] - length of the longest increasing subsequence finishing at a[i]
  int dp[MAX];
  int max = 0;
  for (int i = 0; i < n; i++) {
    dp[i] = 1;
    for (int j = 0; j < i; j++)
      if (a[i] > a[j] && dp[j] + 1 > dp[i])
	dp[i] = dp[j] + 1;
    if (dp[i] > max)
      max = dp[i];
  }
 return max;
}


// position of the first element greater or equal to x (binary search
// of a sorted array)
int lowerBound(int a[], int l, int d, int x) {
  while (l < d) {
    int s = l + (d - l) / 2;
    if (a[s] < x)
      l = s + 1;
    else
      d = s;
  }
  return l;
}

int longestIncreasingSubsequenceDPOptimized(int a[], int n) {
  // dp[k] - smallest possible ending element of an increasing
  // subsequence of lenght k
  int dp[MAX];
  int max = 0;
  for (int i = 0; i < n; i++) {
    int k = lowerBound(dp, 0, max, a[i]);
    dp[k] = a[i];
    if (k + 1 > max)
      max = k + 1;
  }
  return max;
}

#ifdef __TESTING__

#include <iostream>
#include <ctime>
#include <cstdlib>
using namespace std;

int main() {
  /*
  srand(time(NULL));
  int a[MAX];
  int n = rand() % 10 + 1;
  for (int i = 0; i < n; i++)
    a[i] = rand() % 100;
  */

  int a[] = {0, 1}, n = 2;
  cout << longestIncreasingSubsequenceRecursive(a, n) << endl;
  cout << longestIncreasingSubsequenceMemo(a, n) << endl;
  cout << longestIncreasingSubsequenceDP(a, n) << endl;
  cout << longestIncreasingSubsequenceDPOptimized(a, n) << endl;
  return 0;
}

#endif
