
int isPalindrome(char s[], int i, int len) {
  int l = i, r = i + len - 1;
  while (l < r) {
    if (s[l++] != s[r--])
      return 0;
  }
  return 1;
}

int longestPalindromicSubstringBruteForce(char s[], int n) {
  for (int len = n; len >= 1; len--)
    for (int i = 0; i + len - 1 < n; i++)
      if (isPalindrome(s, i, len))
	return len;
  return 0;
}


int longestPalindromicSubstringAnalyzeCenters(char s[], int n) {
  int maxLength = 0;
  for (int i = 0; i < n; i++) {
    int length;
    
    int k = 1;
    while (i - k >= 0 && i + k < n && s[i - k] == s[i + k])
      k++;
    length = 2 * k - 1;

    if (length > maxLength)
      maxLength = length;
    
    k = 0;
    while(i - k >= 0 && i + k + 1 < n && s[i - k] == s[i + k + 1])
      k++;
    length = 2 * k;

    if (length > maxLength)
      maxLength = length;
  }

  return maxLength;
}

int longestPalindromicSubstringManacher(char s[], int n) {
  int N = 2 * n + 1;
  int length[MAX];

  int C = 0, R = 0; // L = C - (R - C)
  for (int i = 0; i < N; i++) {
    int i_sym = C - (i - C);
    if (i < R && i + length[i_sym] < R)
      length[i] = length[i_sym];
    else {
      length[i] = i <= R ? R - i : 0;
      if ((i + length[i]) % 2 == 1)
	length[i]++;
      while (i - length[i] - 1 >= 0 && i + length[i] + 1 < N && 
	     s[(i - length[i] - 1) / 2] == s[(i + length[i] + 1) / 2])
	length[i] += 2;
    }

    if (i + length[i] > R) {
      C = i;
      R = i + length[i];
    }
  }

  int maxLength = 0;
  for (int i = 0; i < N; i++)
    if (length[i] > maxLength)
      maxLength = length[i];

  return maxLength;
}

#ifdef __TESTING__

#include <iostream>
using namespace std;

int main() {
  char s[] = "accabcbaabccbaabcbacbcbb";
  int n = sizeof(s) / sizeof(char);
  cout << longestPalindromicSubstringBruteForce(s, n) << endl;
  cout << longestPalindromicSubstringAnalyzeCenters(s, n) << endl;
  cout << longestPalindromicSubstringManacher(s, n) << endl;
  return 0;
}

#endif
