
int majorityCounting(int a[], int n) {
   int count[MAX] = {0};
   for (int i = 0; i < n; i++)
     count[a[i]]++;
   for (int x = 0; x < MAX; x++)
     if (count[x] > n/2)
        return x;
   return -1;
}

void swap(int a[], int i, int j) {
  int tmp = a[i];
  a[i] = a[j];
  a[j] = tmp;
}

int partition(int a[], int l, int r) {
  int pivot = a[l];
  int last_leq_pivot = l;
  for (int i = l+1; i <= r; i++)
    if (a[i] <= pivot)
      swap(a, i, ++last_leq_pivot);
  swap(a, l, last_leq_pivot);
  return last_leq_pivot;
}

int kthElementQuickSelect(int a[], int n, int k) {
  int l = 0, r = n-1;
  while (l <= r) {
    int pivot_pos = partition(a, l, r);
    if (k < pivot_pos)
      r = pivot_pos-1;
    else if (k > pivot_pos)
      l = pivot_pos+1;
    else
      return a[pivot_pos];
  }
  return -1;
}

int majorityMedian(int a[], int n) {
  int candidate = kthElementQuickSelect(a, n, n/2);
  int count = 0;
  for (int i = 0; i < n; i++)
     if (a[i] == candidate)
	   count++;
  return count > n/2 ? candidate : -1;
}

int majorityBoyerMoore(int a[], int n) {
   int candidate, freq = 0;
   for (int i = 0; i < n; i++)
     if (freq == 0) {
        candidate = a[i]; freq = 1;
     } else {
        if (a[i] == candidate)
          freq++;
        else
          freq--;
     }
   if (freq > 0) {
      int cnt = 0;
      for (int i = 0; i < n; i++)
        if (a[i] == candidate)
          cnt++;
      if (cnt > n/2) return candidate;
   }
   return -1;
}

#ifdef __TESTING__

#include <iostream>
using namespace std;

int main() {
  int a[] = {3, 1, 2, 3, 2, 2, 3, 1, 2, 3, 2, 2, 2, 3, 2, 3, 2};
  int n = sizeof(a) / sizeof(int);
  cout << majorityCounting(a, n) << endl;
  cout << majorityMedian(a, n) << endl;
  cout << majorityBoyerMoore(a, n) << endl;
}

#endif
