int maxSubArraySumBruteForce(int a[], int n) {
  int max = 0;
  for (int i = 0; i < n; i++) {
    int z = 0;
    for (int j = i; j < n; j++) {
      z += a[j];
      if (z > max)
	max = z;
    }
  }
  return max;
}

int maxSubArraySumTwoPointer(int a[], int n) {
  int max = 0;
  int i = 0;
  while (i < n) {
    int z = 0;
    int j;
    for (j = i; j < n; j++) {
      z += a[j];
      if (z < 0)
	break;
      if (z > max)
	max = z;
    }
    i = j + 1;
  }
  return max;
}

int maxSubArraySumKadane(int a[], int n) {
  int max_ending_here = 0, max_so_far = max_ending_here;
  for (int i = 0; i < n; i++) {
    max_ending_here += a[i];
    if (max_ending_here < 0)
      max_ending_here = 0;
    if (max_so_far < max_ending_here)
      max_so_far = max_ending_here;
  }
  return max_so_far;
}

int maxSubArraySumPartialSums(int a[], int n) {
  int partial_sum = 0;
  int min_partial_sum = partial_sum;
  int max = 0;
  for (int i = 0; i < n; i++) {
    partial_sum += a[i];
    int segment_sum = partial_sum - min_partial_sum;
    if (segment_sum > max)
      max = segment_sum;
    if (partial_sum < min_partial_sum)
      min_partial_sum = partial_sum;
  }
  return max;
}

int max3(int a, int b, int c) {
  int max = a;
  if (b > max) max = b;
  if (c > max) max = c;
  return max;
}

int maxSubArraySumDivideAndConquer_(int a[], int l, int d) {
  if (l > d)
    return 0;
  int s = l + (d - l) / 2;
  int max_sum_left = maxSubArraySumDivideAndConquer_(a, l, s-1);
  int max_sum_right = maxSubArraySumDivideAndConquer_(a, s+1, d);
  int sum_middle = a[s];
  int max_sum_middle = sum_middle;
  for (int i = s-1; i >= l; i--) {
    sum_middle += a[i];
    if (sum_middle > max_sum_middle)
      max_sum_middle = sum_middle;
  }
  sum_middle = max_sum_middle;
  for (int i = s+1; i <= d; i++) {
    sum_middle += a[i];
    if (sum_middle > max_sum_middle)
      max_sum_middle = sum_middle;
  }
  return max3(max_sum_left, max_sum_right, max_sum_middle);
}

int maxSubArraySumDivideAndConquer(int a[], int n) {
  return maxSubArraySumDivideAndConquer_(a, 0, n - 1);
}

#ifdef __TESTING__

#include <iostream>
#include <cstdlib>
#include <ctime>
using namespace std;

int main() {
  int n = 3;
  int a[10];
  srand(time(NULL));
  for (int i = 0; i < n; i++)
    a[i] = rand() % 200 - 100;
  cout << maxSubArraySumBruteForce(a, n) << endl;
  cout << maxSubArraySumTwoPointer(a, n) << endl;
  cout << maxSubArraySumKadane(a, n) << endl;
  cout << maxSubArraySumPartialSums(a, n) << endl;
  cout << maxSubArraySumDivideAndConquer(a, n) << endl;
  return 0;
}

#endif
