int numPairsBruteForce(int a[], int n, int d) {
  int num = 0;
  for (int i = 0; i < n; i++)
    for (int j = i+1; j < n; j++) {
      if (a[j] - a[i] == d)
	num++;
      else if (a[j] - a[i] > d)
	break;
    }
  return num;
}

int BinarySearch(int a[], int l, int r, int x) {
  while (l <= r) {
    int s = l + (r - l) / 2;
    if (a[s] < x)
      l = s + 1;
    else
      r = s - 1;
  }
  return l;
}

int numPairsBinarySearch(int a[], int n, int d) {
  int num = 0;
  int i = 0;
  while(i < n) {
    int ii;
    for (ii = i+1; ii < n && a[ii] == a[i]; ii++)
      ;
    int num_ai = ii - i;
    int j = BinarySearch(a, ii, n-1, a[i] + d);
    if (j < n && a[j] == a[i] + d) {
      int jj;
      for (jj = j+1; jj < n && a[jj] == a[j]; jj++)
	;
      int num_aj = jj - j;
      num += num_ai * num_aj;
    }
    i = ii;
  }
  return num;
}



int numPairsTwoPointer(int a[], int n, int d) {
  int num = 0;
  int i = 0, j = 1;
  while (j < n) {
    if (a[j] - a[i] < d)
      j++;
    else if (a[j] - a[i] > d)
      i++;
    else {
      int ii;
      for (ii = i+1; ii < n && a[ii] == a[i]; ii++)
	;
      int num_ai = ii - i;
      i = ii;
      int jj;
      for (jj = j+1; jj < n && a[jj] == a[j]; jj++)
	;
      int num_aj = jj - j;
      j = jj;
      num += num_ai * num_aj;
    }
  }
  return num;
}

#ifdef __TESTING__

#include <iostream>
#include <cstdlib>
#include <ctime>
using namespace std;

int main() {
  srand(time(NULL));
  const int N = 50;
  int a[N];
  a[0] = rand() % 2;
  for (int i = 1; i < N; i++)
     a[i] = a[i-1] + rand() % 2;
  int d = rand() % N / 2 + 1;

  for (int i = 0; i < N; i++)
    cout << a[i] << " ";
  cout << endl;

  cout << d << endl;

  cout << numPairsBinarySearch(a, N, d) << endl;
  cout << numPairsBruteForce(a, N, d) << endl;
  cout << numPairsTwoPointer(a, N, d) << endl;
  return 0;
}

#endif
