int numPairsBruteForce(int a[], int n, int s) {
  int numPairs = 0;
  for (int i = 0; i < n - 1; i++)
    for(int j = i + 1; j < n; j++)
      if (a[i] + a[j] == s)
	    numPairs++;
  return numPairs;
}

int numPairsTwoPointer(int a[], int n, int s) {
  int numPairs = 0;
  int left = 0, right = n - 1;
  while (left < right)
    if (a[left] + a[right] > s)
      right--;
    else if (a[left] + a[right] < s)
      left++;
    else {
      numPairs++;
      left++;
      right--;
  }
  return numPairs;
}


int binarySearch(int a[], int l, int r, int x) {
  while (l <= r) {
    int s = l + (r - l) / 2;
	if (x < a[s])
	  r = s-1;
	else if (x > a[s])
	  l = s+1;
	else
	  return 1;
  }
  return 0;
}

int numPairsBinarySearch(int a[], int n, int s) {
  int brojParova = 0;
  for (int i = 0; i < n - 1; i++)
    if (binarySearch(a, i+1, n-1, s - a[i]))
      brojParova++;
  return brojParova;
}

#ifdef __TESTING__

#include <iostream>
#include <ctime>
#include <cstdlib>
using namespace std;

int main() {
  const int N = 50;
  srand(time(NULL));
  int a[N];
  a[0] = rand() % 2 + 1;
  for (int i = 1; i < N; i++)
    a[i] = a[i-1] + rand() % 2 + 1;
  int s = rand() % a[N-1] + 1;
  cout << numPairsBruteForce(a, N, s) << endl;
  cout << numPairsBinarySearch(a, N, s) << endl;
  cout << numPairsTwoPointer(a, N, s) << endl;
  return 0;
}

#endif
