
int maxPairingGreedyWeakestPupilsWeakestMenthors(int rating[], int n)  {
  // number of pupil-menthor pairs
  int numPairs = 0;
  // indicates if the person already became a menthor
  int isMenthor[MAX];
  for (int i = 0; i < n; i++)
    isMenthor[i] = 0;
   
  // we assign menthors to pupils, starting from the weakest pupils
  // each pupil is assigned a weakest possible unassigned menthor
  for (int pupil = 0, menthor = 1; menthor < n; pupil++)
    // while there is a potential menthor for the current pupil
    while (menthor < n)
      if (!isMenthor[menthor] && rating[menthor] >= 2 * rating[pupil]) {
        // we found a menthor for the current pupil
        numPairs++;
        isMenthor[menthor] = 1;
        break;
      } else
        // we consider another potential menthor
        menthor++;

  return numPairs;
}

int maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic(int rating[], int n)  {
  // number of pupil-menthor pairs
  int numPairs = 0;
  // indicates if the person already became a pupil
  int isPupil[MAX];

  for (int i = 0; i < n; i++)
    isPupil[i] = 0;

  // we assign pupils to menthors, starting from the weakest menthors
  // each menthor is assigned the weakest possible unassigned pupil
  for (int menthor = 1; menthor < n; menthor++)
    for (int pupil = 0; pupil < menthor; pupil++)
      if (!isPupil[pupil] && rating[menthor] >= 2 * rating[pupil]) {
	// we found a pupil for the current menthor
        numPairs++;
        isPupil[pupil] = 1;
        break;
      }
  return numPairs;
}



int maxPairingGreedyStrongestMenthorsStrongestPupils(int rating[], int n)  {
  // number of pupil-menthor pairs
  int numPairs = 0;
  // indicates if the person already became a pupil
  int isPupil[MAX];

  for (int i = 0; i < n; i++)
    isPupil[i] = 0;

  // we assign pupils to menthors, starting from the strongest menthors
  // each menthor is assigned a strongest possible unassigned pupil
  for (int menthor = n-1, pupil = n-2; pupil >= 0; menthor--)
    while (pupil >= 0)
      if (!isPupil[pupil] && rating[menthor] >= 2 * rating[pupil]) {
        // we found a pupil for the current menthor
        numPairs++;
        isPupil[pupil] = 1;
        break;
      } else
	// we consider another potential pupil
	pupil--;

  return numPairs;
}


int maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic(int rating[], int n)  {
  // number of pupil-menthor pairs
  int numPairs = 0;
  // indicates if the person already became a pupil
  int isPupil[MAX];

  for (int i = 0; i < n; i++)
    isPupil[i] = 0;

  // we assign pupils to menthors, starting from the strongest menthors
  // each menthor is assigned a strongest possible unassigned pupil
  for (int menthor = n-1; menthor > 0; menthor--)
    // we seek a pupil for the current menthor by checking all candidates
    // this is suboptimal and can lead to quadratic complexity
    for (int pupil = menthor-1; pupil >= 0; pupil--)
      if (!isPupil[pupil] && rating[menthor] >= 2 * rating[pupil]) {
        // we found a pupil for the current menthor
        numPairs++;
        isPupil[pupil] = 1;
        break;
      }

  return numPairs;
}

// all potential pairings are checked - backtracking search
int maxPairingBruteForce_(int rating[], int n, int menthor, int isPupil[], int numPairs) {
  if (menthor == n)
    return numPairs;

  int max = 0;
  for (int pupil = 0; pupil < menthor; pupil++) {
    if (!isPupil[pupil] && rating[menthor] >= 2*rating[pupil]) {
      isPupil[pupil] = 1;
      int num = maxPairingBruteForce_(rating, n, menthor+1, isPupil, numPairs+1);
      if (num > max)
	max = num;
      isPupil[pupil] = 0;
    }
  }

  int num = maxPairingBruteForce_(rating, n, menthor+1, isPupil, numPairs);
  if (num > max)
    max = num;
  
  return max;
}

int maxPairingBruteForce(int rating[], int n) {
  int isPupil[MAX];
  for (int i = 0; i < n; i++)
    isPupil[i] = 0;
  return maxPairingBruteForce_(rating, n, 0, isPupil, 0);
}

#ifdef __TESTING__

#include <iostream>
#include <algorithm>
#include <cstdlib>
#include <ctime>
using namespace std;

int main() {
  srand(time(NULL));
  int rating[MAX];
  int n = rand() % (MAX - 1) + 1;
  for (int i = 0; i < n; i++)
    rating[i] = rand() % 100;
  sort(rating, rating+n);
  cout << maxPairingGreedyWeakestPupilsWeakestMenthors(rating, n) << endl;
  cout << maxPairingGreedyStrongestMenthorsStrongestPupils(rating, n) << endl;
  cout << maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic(rating, n) << endl;
  cout << maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic(rating, n) << endl;
  cout << maxPairingBruteForce(rating, n) << endl;
  return 0;
}

#endif
