
int prefixSuffixBruteForce(char str[], int n) {
  int maxD = 0;
  for (int d = 1; d < n; d++) {
    int prefix_suffix = 1;
    for (int i = 0, j = n - d; i < d; i++, j++)
      if (str[i] != str[j]) {
	prefix_suffix = 0;
	break;
      }
    if (prefix_suffix)
      maxD = d;
  }

  return maxD;
}


int prefixSuffixKMP1(char str[], int n) {
  int kmp[MAX + 1];
  kmp[0] = kmp[1] = 0;
  for (int i = 1; i < n; i++) {
    int k = kmp[i];
    while (1) {
      if (str[i] == str[k]) {
	kmp[i + 1] = k + 1; break;
      } else if (k == 0) {
	kmp[i + 1] = 0; break;
      } else
	k = kmp[k];
    }
  }  
  return kmp[n];
}

int prefixSuffixKMP2(char str[], int n) {
  int kmp[MAX + 1];
  kmp[0] = -1;
  for (int i = 0; i < n; i++) {
    int k = i;
    while (k > 0 && str[i] != str[kmp[k]])
      k = kmp[k];
    kmp[i + 1] = kmp[k] + 1;
  }
  return kmp[n];
}

