#!/bin/bash
# first argument number of unwindings
# second argument MAX value
# /home/milena/llvm/cbmc/cbmc-5-4-linux-32/
# ../cbmc-5.4

cbmc="/home/milena/llvm/cbmc/cbmc-5-4-linux-32/cbmc"
unwind=$1
maxval=$2
out_dir=Output_$unwind

function check {
    name=$1
    f1=$2
    f2=$3
    echo "timeout 60 time $cbmc $filename -DMAX=$maxval -unwind $unwind -Df1=$f1 -Df2=$f2 >$out_dir/$name.out"
    timeout 60 time $cbmc $filename -DMAX=$maxval -unwind $unwind -Df1=$f1 -Df2=$f2 >$out_dir/$name.out
}


mkdir $out_dir 
echo "mkdir $out_dir"

filename="binarySearch_cbmc.c"
check "linearSearch_binarySearchRec" linearSearch binarySearchRec
check "linearSearch_binarySearchEq" linearSearch binarySearchEq
check "linearSearch_binarySearchGeq1" linearSearch binarySearchGeq1
check "linearSearch_binarySearchGeq2" linearSearch binarySearchGeq2
check "binarySearchRec_binarySearchEq" binarySearchRec binarySearchEq 
check "binarySearchRec_binarySearchGeq1" binarySearchRec binarySearchGeq1
check "binarySearchRec_binarySearchGeq2" binarySearchRec binarySearchGeq2
check "binarySearchEq_binarySearchGeq1" binarySearchEq binarySearchGeq1
check "binarySearchEq_binarySearchGeq2" binarySearchEq binarySearchGeq2
check "binarySearchGeq1_binarySearchGeq2" binarySearchGeq1 binarySearchGeq2  


filename="closestLargerPredecesor_cbmc.c"
check "closestLargerPredecesorBruteForce_closestLargerPredecesorMaximumsStack" closestLargerPredecesorBruteForce closestLargerPredecesorMaximumsStack  


filename="fib_cbmc.c"
check "fibRecursive_fibMemo" fibRecursive fibMemo
check "fibRecursive_fibDP" fibRecursive fibDP
check "fibRecursive_fibDPMemOptimized" fibRecursive fibDPMemOptimized
check "fibMemo_fibDP" fibMemo fibDP 
check "fibMemo_fibDPMemOptimized" fibMemo fibDPMemOptimized
check "fibDP_fibDPMemOptimized" fibDP fibDPMemOptimized


filename="kthElement_cbmc.c"
check "kthElementQuickSelect_kthElementSelectionSort" kthElementQuickSelect kthElementSelectionSort
check "kthElementQuickSelect_kthElementQuickSort" kthElementQuickSelect kthElementQuickSort
check "kthElementSelectionSort_kthElementQuickSort" kthElementSelectionSort kthElementQuickSort 

filename="longestIncreasingSubsequence_cbmc.c"
check "longestIncreasingSubsequenceRecursive_longestIncreasingSubsequenceMemo" longestIncreasingSubsequenceRecursive longestIncreasingSubsequenceMemo
check "longestIncreasingSubsequenceRecursive_longestIncreasingSubsequenceDP" longestIncreasingSubsequenceRecursive longestIncreasingSubsequenceDP
check "longestIncreasingSubsequenceRecursive_longestIncreasingSubsequenceDPOptimized" longestIncreasingSubsequenceRecursive longestIncreasingSubsequenceDPOptimized
check "longestIncreasingSubsequenceMemo_longestIncreasingSubsequenceDP" longestIncreasingSubsequenceMemo longestIncreasingSubsequenceDP
check "longestIncreasingSubsequenceMemo_longestIncreasingSubsequenceDPOptimized" longestIncreasingSubsequenceMemo longestIncreasingSubsequenceDPOptimized
check "longestIncreasingSubsequenceDP_longestIncreasingSubsequenceDPOptimized" longestIncreasingSubsequenceDP longestIncreasingSubsequenceDPOptimized


filename="longestPalindromicSubstring_cbmc.c"
check "longestPalindromicSubstringBruteForce_longestPalindromicSubstringAnalyzeCenters" longestPalindromicSubstringBruteForce longestPalindromicSubstringAnalyzeCenters 
check "longestPalindromicSubstringBruteForce_longestPalindromicSubstringManacher" longestPalindromicSubstringBruteForce longestPalindromicSubstringManacher 
check "longestPalindromicSubstringAnalyzeCenters_longestPalindromicSubstringManacher" longestPalindromicSubstringAnalyzeCenters longestPalindromicSubstringManacher 


filename="majority_cbmc.c"
check "majorityCounting_majorityMedian" majorityCounting majorityMedian
check "majorityCounting_majorityBoyerMoore" majorityCounting majorityBoyerMoore  
check "majorityMedian_majorityBoyerMoore" majorityMedian majorityBoyerMoore 



filename="maxSubarraySum_cbmc.c"
check "maxSubArraySumBruteForce_maxSubArraySumTwoPointer" maxSubArraySumBruteForce maxSubArraySumTwoPointer
check "maxSubArraySumBruteForce_maxSubArraySumKadane" maxSubArraySumBruteForce maxSubArraySumKadane
check "maxSubArraySumBruteForce_maxSubArraySumPartialSums" maxSubArraySumBruteForce maxSubArraySumPartialSums
check "maxSubArraySumBruteForce_maxSubArraySumDivideAndConquer" maxSubArraySumBruteForce maxSubArraySumDivideAndConquer
check "maxSubArraySumTwoPointer_maxSubArraySumKadane" maxSubArraySumTwoPointer maxSubArraySumKadane
check "maxSubArraySumTwoPointer_maxSubArraySumPartialSums" maxSubArraySumTwoPointer maxSubArraySumPartialSums
check "maxSubArraySumTwoPointer_maxSubArraySumDivideAndConquer" maxSubArraySumTwoPointer maxSubArraySumDivideAndConquer 
check "maxSubArraySumKadane_maxSubArraySumPartialSums" maxSubArraySumKadane maxSubArraySumPartialSums
check "maxSubArraySumKadane_maxSubArraySumDivideAndConquer" maxSubArraySumKadane maxSubArraySumDivideAndConquer
check "maxSubArraySumPartialSums_maxSubArraySumDivideAndConquer" maxSubArraySumPartialSums maxSubArraySumDivideAndConquer
  
filename="numOfSegmentsWithGivenSum_cbmc.c"
check "numOfSegmentsWithGivenSumPartialSumsTwoPointer_numOfSegmentsWithGivenSumBruteForce" numOfSegmentsWithGivenSumPartialSumsTwoPointer numOfSegmentsWithGivenSumBruteForce 
check "numOfSegmentsWithGivenSumPartialSumsTwoPointer_numOfSegmentsWithGivenSumTwoPointer" numOfSegmentsWithGivenSumPartialSumsTwoPointer numOfSegmentsWithGivenSumTwoPointer 
check "numOfSegmentsWithGivenSumBruteForce_numOfSegmentsWithGivenSumTwoPointer" numOfSegmentsWithGivenSumBruteForce numOfSegmentsWithGivenSumTwoPointer 


filename="numPairsWithGivenDifference_cbmc.c"
check "numPairsBinarySearch_numPairsBruteForce" numPairsBinarySearch numPairsBruteForce
check "numPairsBinarySearch_numPairsTwoPointer" numPairsBinarySearch numPairsTwoPointer
check "numPairsBruteForce_numPairsTwoPointer" numPairsBruteForce numPairsTwoPointer


filename="numPairsWithGivenSum_cbmc.c"
check "numPairsBruteForce_numPairsBinarySearch" numPairsBruteForce numPairsBinarySearch 
check "numPairsBruteForce_numPairsTwoPointer" numPairsBruteForce numPairsTwoPointer 
check "numPairsBinarySearch_numPairsTwoPointer" numPairsBinarySearch numPairsTwoPointer

filename="optimalPairing_cbmc.c"
check "maxPairingGreedyWeakestPupilsWeakestMenthors_maxPairingGreedyStrongestMenthorsStrongestPupils" maxPairingGreedyWeakestPupilsWeakestMenthors maxPairingGreedyStrongestMenthorsStrongestPupils 
check "maxPairingGreedyWeakestPupilsWeakestMenthors_maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic" maxPairingGreedyWeakestPupilsWeakestMenthors maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic
check "maxPairingGreedyWeakestPupilsWeakestMenthors_maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic" maxPairingGreedyWeakestPupilsWeakestMenthors maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic 
check "maxPairingGreedyWeakestPupilsWeakestMenthors_maxPairingBruteForce" maxPairingGreedyWeakestPupilsWeakestMenthors maxPairingBruteForce 
check "maxPairingGreedyStrongestMenthorsStrongestPupils_maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic" maxPairingGreedyStrongestMenthorsStrongestPupils maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic 
check "maxPairingGreedyStrongestMenthorsStrongestPupils_maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic" maxPairingGreedyStrongestMenthorsStrongestPupils maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic 
check "maxPairingGreedyStrongestMenthorsStrongestPupils_maxPairingBruteForce" maxPairingGreedyStrongestMenthorsStrongestPupils maxPairingBruteForce 
check "maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic_maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic" maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic  maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic 
check "maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic_maxPairingBruteForce" maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic maxPairingBruteForce
check "maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic_maxPairingBruteForce" maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic maxPairingBruteForce 


filename="sorting_cbmc.c"
check "selectionSortSwaps_selectionSortPosMinimum" selectionSortSwaps selectionSortPosMinimum
check "selectionSortSwaps_insertionSortSwaps" selectionSortSwaps insertionSortSwaps
check "selectionSortSwaps_insertionSortOptimized" selectionSortSwaps insertionSortOptimized
check "selectionSortSwaps_quickSort1" selectionSortSwaps quickSort1
check "selectionSortSwaps_quickSort2" selectionSortSwaps quickSort2
check "selectionSortSwaps_mergeSort" selectionSortSwaps mergeSort
check "selectionSortPosMinimum_insertionSortSwaps" selectionSortPosMinimum insertionSortSwaps
check "selectionSortPosMinimum_insertionSortOptimized" selectionSortPosMinimum insertionSortOptimized
check "selectionSortPosMinimum_quickSort1" selectionSortPosMinimum quickSort1
check "selectionSortPosMinimum_quickSort2" selectionSortPosMinimum quickSort2
check "selectionSortPosMinimum_mergeSort" selectionSortPosMinimum mergeSort
check "insertionSortSwaps_insertionSortOptimized" insertionSortSwaps insertionSortOptimized
check "insertionSortSwaps_quickSort1" insertionSortSwaps quickSort1
check "insertionSortSwaps_quickSort2" insertionSortSwaps quickSort2
check "insertionSortSwaps_mergeSort" insertionSortSwaps mergeSort
check "insertionSortOptimized_quickSort1" insertionSortOptimized quickSort1
check "insertionSortOptimized_quickSort2" insertionSortOptimized quickSort2
check "insertionSortOptimized_mergeSort" insertionSortOptimized mergeSort
check "quickSort1_quickSort2" quickSort1 quickSort2
check "quickSort1_mergeSort" quickSort1 mergeSort
check "quickSort2_mergeSort" quickSort2 mergeSort

filename="coinChange_cbmc.c"
check "minCoinsRecursive_minCoinsMemo" minCoinsRecursive minCoinsMemo
check "minCoinsRecursive_minCoinsDP" minCoinsRecursive minCoinsDP
check "minCoinsRecursive_minCoinsRecursive1" minCoinsRecursive minCoinsRecursive1
check "minCoinsRecursive_minCoinsRecursive1" minCoinsRecursive minCoinsRecursive1
check "minCoinsRecursive_minCoinsDP1" minCoinsRecursive minCoinsDP1
check "minCoinsMemo_minCoinsDP" minCoinsMemo minCoinsDP
check "minCoinsMemo_minCoinsRecursive1" minCoinsMemo minCoinsRecursive1
check "minCoinsMemo_minCoinsMemo1" minCoinsMemo minCoinsMemo1
check "minCoinsMemo_minCoinsDP1" minCoinsMemo minCoinsDP1
check "minCoinsDP_minCoinsRecursive1" minCoinsDP minCoinsRecursive1 
check "minCoinsDP_minCoinsMemo1" minCoinsDP minCoinsMemo1
check "minCoinsDP_minCoinsDP1" minCoinsDP minCoinsDP1
check "minCoinsRecursive1_minCoinsMemo1" minCoinsRecursive1 minCoinsMemo1
check "minCoinsRecursive1_minCoinsDP1" minCoinsRecursive1 minCoinsDP1
check "minCoinsMemo1_minCoinsDP1" minCoinsMemo1 minCoinsDP1

filename="prefixSuffix_cbmc.c"
check "prefixSuffixBruteForce_prefixSuffixKMP1" prefixSuffixBruteForce prefixSuffixKMP1
check "prefixSuffixBruteForce_prefixSuffixKMP2" prefixSuffixBruteForce prefixSuffixKMP2
check "prefixSuffixKMP1_prefixSuffixKMP2" prefixSuffixKMP1 prefixSuffixKMP2

#for filename in $out_dir/*; do
#    echo $filename
#    cat $filename
#done







