#!/bin/bash
# first argument number of unwindings
# second argument MAX value

lav="LAV"
unwind=$1
maxval=$2
out_dir=Output_$unwind

function check {
    num=$1
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o"
    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -skip-inside-loop=false -loop-unroll-begin=$unwind -loop-unroll-end=0 -track-unreachable=false $f1$f2.o -output-folder="$out_dir" >izl"
    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -skip-inside-loop=false -loop-unroll-begin=$unwind -loop-unroll-end=0 -track-unreachable=false $f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $f1$f2.o
}


mkdir $out_dir 
echo "mkdir $out_dir"

filename="binarySearch_lav.c"
check "linearSearch_binarySearchEq" linearSearch binarySearchEq
check "linearSearch_binarySearchGeq1" linearSearch binarySearchGeq1
check "linearSearch_binarySearchGeq2" linearSearch binarySearchGeq2
check "binarySearchEq_binarySearchGeq1" binarySearchEq binarySearchGeq1
check "binarySearchEq_binarySearchGeq2" binarySearchEq binarySearchGeq2
check "binarySearchGeq1_binarySearchGeq2" binarySearchGeq1 binarySearchGeq2  

filename="closestLargerPredecesor_lav.c"
check "closestLargerPredecesorBruteForce_closestLargerPredecesorMaximumsStack" closestLargerPredecesorBruteForce closestLargerPredecesorMaximumsStack  

filename="kthElement_lav.c"
check "kthElementQuickSelect_kthElementSelectionSort" kthElementQuickSelect kthElementSelectionSort

filename="longestIncreasingSubsequence_lav.c"
$check "longestIncreasingSubsequenceMemo_longestIncreasingSubsequenceDPOptimized" longestIncreasingSubsequenceMemo longestIncreasingSubsequenceDPOptimized
check "longestIncreasingSubsequenceDP_longestIncreasingSubsequenceDPOptimized" longestIncreasingSubsequenceDP longestIncreasingSubsequenceDPOptimized

filename="longestPalindromicSubstring_lav.c"
check "longestPalindromicSubstringBruteForce_longestPalindromicSubstringAnalyzeCenters" longestPalindromicSubstringBruteForce longestPalindromicSubstringAnalyzeCenters 

filename="majority_lav.c"
check "majorityMedian_majorityBoyerMoore" majorityMedian majorityBoyerMoore 

filename="maxSubarraySum_lav.c"
check "maxSubArraySumBruteForce_maxSubArraySumTwoPointer" maxSubArraySumBruteForce maxSubArraySumTwoPointer
check "maxSubArraySumBruteForce_maxSubArraySumKadane" maxSubArraySumBruteForce maxSubArraySumKadane
check "maxSubArraySumBruteForce_maxSubArraySumPartialSums" maxSubArraySumBruteForce maxSubArraySumPartialSums
check "maxSubArraySumTwoPointer_maxSubArraySumKadane" maxSubArraySumTwoPointer maxSubArraySumKadane
check "maxSubArraySumTwoPointer_maxSubArraySumPartialSums" maxSubArraySumTwoPointer maxSubArraySumPartialSums
check "maxSubArraySumKadane_maxSubArraySumPartialSums" maxSubArraySumKadane maxSubArraySumPartialSums

filename="numOfSegmentsWithGivenSum_lav.c"
check "numOfSegmentsWithGivenSumPartialSumsTwoPointer_numOfSegmentsWithGivenSumBruteForce" numOfSegmentsWithGivenSumPartialSumsTwoPointer numOfSegmentsWithGivenSumBruteForce 
check "numOfSegmentsWithGivenSumPartialSumsTwoPointer_numOfSegmentsWithGivenSumTwoPointer" numOfSegmentsWithGivenSumPartialSumsTwoPointer numOfSegmentsWithGivenSumTwoPointer 
check "numOfSegmentsWithGivenSumBruteForce_numOfSegmentsWithGivenSumTwoPointer" numOfSegmentsWithGivenSumBruteForce numOfSegmentsWithGivenSumTwoPointer 

filename="numPairsWithGivenDifference_lav.c"
check "numPairsBinarySearch_numPairsBruteForce" numPairsBinarySearch numPairsBruteForce
check "numPairsBinarySearch_numPairsTwoPointer" numPairsBinarySearch numPairsTwoPointer
check "numPairsBruteForce_numPairsTwoPointer" numPairsBruteForce numPairsTwoPointer

filename="numPairsWithGivenSum_lav.c"
check "numPairsBruteForce_numPairsBinarySearch" numPairsBruteForce numPairsBinarySearch 
check "numPairsBruteForce_numPairsTwoPointer" numPairsBruteForce numPairsTwoPointer 
check "numPairsBinarySearch_numPairsTwoPointer" numPairsBinarySearch numPairsTwoPointer

filename="optimalPairing_lav.c"
check "maxPairingGreedyWeakestPupilsWeakestMenthors_maxPairingGreedyStrongestMenthorsStrongestPupils" maxPairingGreedyWeakestPupilsWeakestMenthors maxPairingGreedyStrongestMenthorsStrongestPupils 
check "maxPairingGreedyWeakestPupilsWeakestMenthors_maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic" maxPairingGreedyWeakestPupilsWeakestMenthors maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic
check "maxPairingGreedyWeakestPupilsWeakestMenthors_maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic" maxPairingGreedyWeakestPupilsWeakestMenthors maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic 
check "maxPairingGreedyStrongestMenthorsStrongestPupils_maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic" maxPairingGreedyStrongestMenthorsStrongestPupils maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic 
check "maxPairingGreedyStrongestMenthorsStrongestPupils_maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic" maxPairingGreedyStrongestMenthorsStrongestPupils maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic 
check "maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic_maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic" maxPairingGreedyWeakestMenthorsWeakestStudentsQuadratic  maxPairingGreedyStrongestMenthorsStrongestPupilsQuadratic 

filename="sorting_lav.c"
check "selectionSortSwaps_selectionSortPosMinimum" selectionSortSwaps selectionSortPosMinimum
check "selectionSortSwaps_insertionSortSwaps" selectionSortSwaps insertionSortSwaps
check "selectionSortSwaps_insertionSortOptimized" selectionSortSwaps insertionSortOptimized
check "selectionSortPosMinimum_insertionSortSwaps" selectionSortPosMinimum insertionSortSwaps
check "selectionSortPosMinimum_insertionSortOptimized" selectionSortPosMinimum insertionSortOptimized
check "insertionSortSwaps_insertionSortOptimized" insertionSortSwaps insertionSortOptimized

filename="coinChange_lav.c"
check "minCoinsDP_minCoinsDP1" minCoinsDP minCoinsDP1

filename="prefixSuffix_lav.c"
check "prefixSuffixBruteForce_prefixSuffixKMP1" prefixSuffixBruteForce prefixSuffixKMP1
check "prefixSuffixBruteForce_prefixSuffixKMP2" prefixSuffixBruteForce prefixSuffixKMP2
check "prefixSuffixKMP1_prefixSuffixKMP2" prefixSuffixKMP1 prefixSuffixKMP2


for filename in $out_dir/*; do
    echo $filename
    cat $filename
done


