void swap(int a[], int i, int j) {
  int tmp = a[i];
  a[i] = a[j];
  a[j] = tmp;
}

void selectionSortPosMinimum(int a[], int n) {
  for (int i = 0; i < n - 1; i++) {
    int pos = i;
    for (int j = i+1; j < n; j++) {
      if (a[j] < a[pos])
	pos = j;
    }
    if (pos != i)
      swap(a, pos, i);
  }
}

void selectionSortSwaps(int a[], int n) {
  for (int i = 0; i < n; i++)
    for (int j = i+1; j < n; j++)
      if (a[i] > a[j])
	swap(a, i, j);
}

void insertionSortSwaps(int a[], int n) {
  for (int i = 1; i < n; i++) {
    int tmp = a[i];
    int j;
    for (j = i - 1; j >= 0 && a[j] > tmp; j--)
      swap(a, j, j+1);
    a[j+1] = tmp;
  }
}

void insertionSortOptimized(int a[], int n) {
   for (int i = 1; i < n; i++) {
      int tmp = a[i];
      int j;
      for (j = i - 1; j >= 0 && a[j] > tmp; j--) {
        int tmp = a[j]; a[j] = a[j+1]; a[j+1] = tmp;
      }
      a[j+1] = tmp;
   }
}

void quickSort11(int a[], int l, int d) {
  if (l < d) {
    int pivot = a[l];
    int last_leq_pivot = l;
    for (int i = l + 1; i <= d; i++)
      if (a[i] <= pivot)
	swap(a, i, ++last_leq_pivot);
    swap(a, l, last_leq_pivot);
    quickSort11(a, l, last_leq_pivot-1);
    quickSort11(a, last_leq_pivot+1, d);
  }
}

void quickSort22(int a[], int l, int d) {
  if (l < d) {
    int pivot = a[l];
    int i = l+1, j = d;
    while (i <= j) {
      if (a[i] <= pivot)
	i++;
      else if (a[j] > pivot)
	j--;
      else {
	swap(a, i, j);
	i++; j--;
      }
    }
    swap(a, l, j);
    quickSort22(a, l, j-1);
    quickSort22(a, j+1, d);
  }
}

void quickSort1(int a[], int n) {
  quickSort11(a, 0, n-1);
}

void quickSort2(int a[], int n) {
  quickSort22(a, 0, n-1);
}

void mergeSort1(int a[], int l, int d, int b[]) {
  if (l < d) {
    int s = l + (d - l) / 2;
    mergeSort1(a, l, s, b);
    mergeSort1(a, s+1, d, b);
    int i = l, j = s + 1, k = l;
    while (i <= s && j <= d) {
      if (a[i] <= a[j])
	b[k++] = a[i++];
      else
	b[k++] = a[j++];
    }
    while (i <= s)
      b[k++] = a[i++];
    while (j <= d)
      b[k++] = a[j++];
    for (int i = l; i <= d; i++)
      a[i] = b[i];
  }
}

void mergeSort(int a[], int n) {
  int b[MAX];
  mergeSort1(a, 0, n-1, b);
}


#ifdef __TESTING__

#include <iostream>
using namespace std;


void print(int a[], int n) {
  for (int i = 0; i < n; i++)
    cout << a[i] << " ";
  cout << endl;
}

int main() {
   int a1[] = {5, 3, 8, 2, 4, 6, 1, 7, 9, 0};
   int n1 = sizeof(a1) / sizeof(int);
   mergeSort(a1, n1);
   print(a1, n1);
   return 0;
}

#endif
