#!/bin/bash
# first argument MAX value

lav="LAV"
maxval=$1
out_dir=Output

function check {
    num=$1
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o"
#    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl"
#    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $f1$f2.o
}

mkdir $out_dir

filename="day_number_lav.c"
check "day_number1_day_number2" day_number1 day_number2
check "day_number1_day_number3" day_number1 day_number3
check "day_number2_day_number3" day_number2 day_number3

filename="vowels_lav.c"
check "vowels_1_2" vowels1 vowels2

#for filename in $out_dir/*; do
#    echo $filename
#    cat $filename
#done
