#include <math.h>

enum num {NO, ONE, TWO, INF};

int quadratic1(int a, int b, int c, int* x1, int* x2) {
  enum num n = NO;
  int d = b*b - 4*a*c;
  if (a != 0 && d>0) {
    n = TWO;
    *x1 = (-b+sqrt(d))/(2*a);
    *x2 = (-b-sqrt(d))/(2*a);
  }
  if (a != 0 && d==0) {
    n = ONE;
    *x1 = (-b)/(2*a);
    *x2 = (-b)/(2*a);
  }
  if (a != 0 && d<0) {
    n = NO;
    *x1 = 0;
    *x2 = 0;
  }
  if (a == 0 && b == 0 && c == 0) {
    n = INF;
    *x1 = 0;
    *x2 = 0;
  }
  if (a == 0 && b == 0 && c != 0) {
    n = NO;
    *x1 = 0;
    *x2 = 0;
  }
  if (a == 0 && b != 0) {
    n = ONE;
    *x1 = -c/b;
    *x2 = 0;
  }
  return n;
}

int quadratic2(int a, int b, int c, int* x1, int* x2) {
  if (a == 0) {
    // linear equation
    *x2 = 0;
    if (b == 0) {
      *x1 = 0;
      return c == 0 ? INF : NO;
    } else {
      *x1 = -c/b;
      return ONE;
    }
  } else {
    // genuine quadratic equation
    int d = b * b - 4 * a * c;
    if (d < 0) {
      *x1 = *x2 = 0;
      return NO;
    } else if(d == 0) {       *
        x1 = *x2 = -b / (2*a);
      return ONE;
    } else {
      *x1 = (-b + sqrt(d)) / (2 * a);
      *x2 = (-b - sqrt(d)) / (2 * a);
      return TWO;
    }
  }
}
