#!/bin/bash
# first argument MAX value

lav="LAV"
maxval=$1
out_dir=Output

function check {
    num=$1
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o"
#    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false  -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl"
#    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false  -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $f1$f2.o
}

mkdir $out_dir

filename="linear_eq_lav.c"
check "linear_eq" linear_eq1 linear_eq2

filename="quadrant_lav.c"
check "quadrant" quadrant1 quadrant2

filename="quadratic_eq_lav.c"
check "quadratic_eq" quadratic_eq1 quadratic_eq2

filename="triangle_lav.c"
check "triangle" triangle1 triangle2

#for filename in $out_dir/*; do
#    echo $filename
#    cat $filename
#done
