#!/bin/bash
# first argument MAX value

lav="LAV"
maxval=$1
out_dir=Output

function check {
    num=$1
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o"
#    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false  -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl"
#    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false  -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $f1$f2.o
}


mkdir $out_dir

filename="better_lav.c"
check "better" bolji1 bolji2

filename="legal_age_lav.c"
check "legal_age" legal_age1 legal_age2

filename="time_lav.c"
check "time12" ko_je_pre1 ko_je_pre2
check "time13" ko_je_pre1 ko_je_pre3
check "time23" ko_je_pre2 ko_je_pre3

#for filename in $out_dir/*; do
#    echo $filename
#    cat $filename
#done
