#!/bin/bash
# first argument MAX value

lav="LAV"
maxval=$1
out_dir=Output

function check {
    num=$1
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o"
#    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false  -track-unreachable=false $f1$f2.o -output-folder="$out_dir" >izl"
#    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false  -track-unreachable=false $f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $f1$f2.o
}
function checkcpp {
    num=$1
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -std=c++11 -stdlib=libstdc++ -I/usr/include/i386-linux-gnu/c++/4.8 -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o"
#    echo $K
    clang -c -g -emit-llvm -std=c++11 -stdlib=libstdc++ -I/usr/include/i386-linux-gnu/c++/4.8 -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false  -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl"
#    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $f1$f2.o
}


mkdir $out_dir

filename="max3_lav.c"
check "max3_12" max3_1 max3_2
check "max3_13" max3_1 max3_3
check "max3_23" max3_2 max3_3

filename="max4_lav.c"
check "max4_12" max4_1 max4_2
check "max4_13" max4_1 max4_3
check "max4_23" max4_2 max4_3

filename="sumo_lav.cpp"
checkcpp "sumo" sumo1 sumo2

#for filename in $out_dir/*; do
#    echo $filename
#    cat $filename
#done
