#include <algorithm>
using namespace std;

// sort 4 numbers so that a >= b >= c >= d
void sort(int& a, int& b, int& c, int& d) {
  if (a < b) swap(a, b);
  if (a < c) swap(a, c);
  if (a < d) swap(a, d);
  if (b < c) swap(b, c);
  if (b < d) swap(b, d);
  if (c < d) swap(c, d);
}

int sumo1(int a, int b, int c, int d, int L)
{
  // sort weights
  sort(a, b, c, d);

  // number of elevator rides
  int numRides;
  if (a+b+c+d <= L)
    numRides = 1;
  else if ((a+d <= L && b+c <= L) || b+c+d <= L)
    numRides = 2;
  else if (c+d <= L)
    numRides = 3;
  else
    numRides = 4;

  return numRides;
}

int sumo2(int a, int b, int c, int d, int L)
{
  // number of elevator rides
  int numRides;
  if (a+b+c+d <= L)
    numRides = 1;
  else if ((a+b <= L && c+d <= L) ||
   (a+c <= L && b+d <= L) ||
   (a+d <= L && b+c <= L) ||
   (a+b+c <= L /* && d <= L*/ ) ||
   (a+b+d <= L /* && c <= L*/ ) ||
   (a+c+d <= L /* && b <= L*/ ) ||
   (b+c+d <= L /* && a <= L*/ ))
    numRides = 2;
  else if (a+b <= L /* && c <= L && d <= L */ ||
   a+c <= L /* && b <= L && d <= L */ ||
   a+d <= L /* && b <= L && c <= L */ ||
   b+c <= L /* && a <= L && d <= L */ ||
   b+d <= L /* && a <= L && c <= L */ ||
   c+d <= L /* && a <= L && b <= L */)
    numRides = 3;
  else
    numRides = 4;

  return numRides;
}
