#!/bin/bash
# first argument MAX value

lav="LAV"
maxval=$1
out_dir=Output

function check {
    num=$1
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o"
#    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false  -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl"
#    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false  -track-unreachable=true $f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $f1$f2.o
}

mkdir $out_dir

filename="grade_lav.c"
check "grade" grade1 grade2
check "grade" grade1 grade3
check "grade" grade2 grade3

filename="water_lav.c"
check "water" water1 water2
check "water" water1 water3
check "water" water1 water4
check "water" water1 water5
check "water" water2 water3
check "water" water2 water4
check "water" water2 water5
check "water" water3 water4
check "water" water3 water5
check "water" water4 water5

#for filename in $out_dir/*; do
#    echo $filename
#    cat $filename
#done
