#!/bin/bash
# first argument MAX value

lav="LAV"
maxval=$1
out_dir=Output

function check {
    num=$1\_
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o"
    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl"
    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $num$f1$f2.o
}

mkdir $out_dir

filename="fact_lav.c"
check fact fact1 fact2
check fact fact3 fact4
check fact fact3 fact5
check fact fact4 fact5

filename="count_digits_lav.c"
check count count1 count2

filename="geo_ij_lav.c"
check geoij geo1 geo2

filename="geo_lav.c"
check geo geo1 geo2

filename="sum_digits_lav.c"
check sum_digits sum_digits1 sum_digits2

filename="sum_ij_lav.c"
check sum_ij sum1 sum2

filename="sum_lav.c"
check sum sum1 sum2

for filename in $out_dir/*; do
    echo $filename
    cat $filename
done

