#!/bin/bash
# first argument MAX value

lav="LAV"
maxval=$1
out_dir=Output

function check {
    num=$1\_
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o"
    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl"
    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $num$f1$f2.o
}

function checkbv {
    num=$1\_
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o"
    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-BV-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl"
    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-BV-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $num$f1$f2.o
}

mkdir $out_dir

filename="check_adjacent_lav.c"
check check_adjacent check_adjacent1 check_adjacent2

filename="equal_lav.c"
check equal equal1 equal2

filename="find_first_div_k_lav.c"
check ffgk find_first_div_k1 find_first_div_k2

filename="is_sorted_lav.c"
check is_sorted is_sorted1 is_sorted2

filename="positive_lav.c"
check positive positive1 positive2

filename="r2m3_lav.c"
checkbv r2m3 r2m31 r2m32

for filename in $out_dir/*; do
    echo $filename
    cat $filename
done
