#!/bin/bash
# first argument MAX value

lav="LAV"
maxval=$1
out_dir=Output

function check {
    num=$1
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o"
    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl"
    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $num$f1$f2.o
}

function checkbv {
    num=$1\_
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o"
    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-BV-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl"
    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-BV-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $num$f1$f2.o
}

mkdir $out_dir

filename="euclid_lav.c"
check euclid euclid1 euclid2

filename="filter_sum_lav.c"
check filter_sum filter_sum1 filter_sum2

filename="max_even_lav.c"
check max_even max_even1 max_even2

filename="number_positive_lav.c"
check number_positive number_positive1 number_positive2

filename="pack_lav.c"
check pack pack1 pack2

filename="product_not_equal_lav.c"
check product_not_equal product_not_equal1 product_not_equal2

filename="product_square_even_lav.c"
check product_square_even product_square_even1 product_square_even2

filename="sum_abs_lav.c"
check sum_abs sum_abs1 sum_abs2
check sum_abs sum_abs1 sum_abs3
check sum_abs sum_abs2 sum_abs3

filename="sum_less_than_lav.c"
check sum_less_than sum_less_than1 sum_less_than2

filename="sum_square_odd_digits_lav.c"
checkbv sum_square_odd_digits sum1 sum2


for filename in $out_dir/*; do
    echo $filename
    cat $filename
done

