#!/bin/bash
# first argument MAX value

lav="LAV"
maxval=$1
out_dir=Output

function check {
    num=$1
    f1=$2
    f2=$3
    K="clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o"
    echo $K
    clang -c -g -emit-llvm -DMAX=$maxval -Df1=$f1 -Df2=$f2 $filename -o $num$f1$f2.o       
    K="timeout 60 LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl"
    echo $K
    timeout 60 time LAV -check-div-zero=false -solver=Z3-LA-ARR-EUF -check-pointers=false -track-unreachable=true $num$f1$f2.o -output-folder="$out_dir" >izl
    rm izl
    rm $num$f1$f2.o
}

mkdir $out_dir

filename="competition_lav.c"
check competition competition1 competition2

filename="students_lav.c"
check students students1 students2

filename="date_lav.c"
check date greater_dates1 greater_dates2

filename="square_lav.c"
check square square1 square2

for filename in $out_dir/*; do
    echo $filename
    cat $filename
done

