#ifndef _GRAPH_
#define _GRAPH_
using namespace std;

#include <stdio.h>
#include <vector>
#include <string>
#include <assert.h>

class Graph
{
private:
    vector<int> labels;
    vector<int> out_edges_count;
    vector<int> edges;
    vector<vector<int> *> nodes;
    void LoadGraph(FILE *f)
    {
	int n1, n2, nc;
        fscanf(f,"%u", &nc);
	for(int i=0; i<nc; i++)
	{
	    nodes.push_back(new vector<int>);
	    out_edges_count.push_back(0);
	}
	while(1)
	{
	    fscanf(f,"%d %d",&n1,&n2);
	    if(feof(f))
		break;
	    assert(0<n1 && n1<=nc);
	    assert(0<n2 && n2<=nc);
	    AddEdge(n1-1,n2-1);
	}
    }
    void LoadGraph(char *matrix, int n, vector<int> *l)
    {
	for(int i=0; i<n; i++)
	{
	    nodes.push_back(new vector<int>);
	    out_edges_count.push_back(0);
	}
	for(int i=0; i<n; i++)
	    for(int j=0; j<n; j++)
		if(matrix[i*n+j])
		    AddEdge(j,i);
    }
    void AddEdge(int n1, int n2)
    {
	edges.push_back(n1);
	edges.push_back(n2);
	if(nodes[n1]->size()==0)
	    nodes[n1]->push_back(edges.size()/2-1);
	else
    	    nodes[n1]->insert(nodes[n1]->begin(),edges.size()/2-1);
	out_edges_count[n1]++;
    	nodes[n2]->push_back(edges.size()/2-1);
    }
    void Clear()
    {
	for(unsigned i=0; i<nodes.size(); i++)
	    delete nodes[i];
	nodes.clear();
	out_edges_count.clear();
	edges.clear();
    }
public:
    Graph(string file_name)
    {
	Reload(file_name);
    }
    Graph(char *matrix, int n, vector<int> *l)
    {
	Reload(matrix, n, l);
    }
    ~Graph()
    {
	for(unsigned i=0; i<nodes.size(); i++)
	    delete nodes[i];
    }
    void Reload(string file_name)
    {
	FILE *f;
	Clear();
	if((f=fopen(file_name.c_str(),"r"))==0)
	{
	    printf("File %s can't be opened!\n",file_name.c_str());
	    throw "";
	}
	LoadGraph(f);
	fclose(f);
    }
    void Reload(char *matrix, int n, vector<int> *l)
    {
	Clear();
	if(!matrix)
	{
	    printf("Invalid matrix!\n");
	    throw "";
	}
	LoadGraph(matrix, n, l);
    }
    int NodeCount()
    {
	return nodes.size();
    }
    int EdgeCount()
    {
	return edges.size()/2;
    }
    int SourceNode(int edge_no)
    {
	return edges[2*edge_no];
    }
    int TerminatingNode(int edge_no)
    {
	return edges[2*edge_no+1];
    }
    void EnumBeginningEdges(int node, vector<int>::iterator *array, int *length)
    {
	if(array)
	    *array=nodes[node]->begin();
	if(length)
	    *length=BeginningEdgesCount(node);
    }
    void EnumTerminatingEdges(int node, vector<int>::iterator *array, int *length)
    {
	if(array)
	    *array=nodes[node]->begin()+out_edges_count[node];
	if(length)
	    *length=TerminatingEdgesCount(node);
    }
    int BeginningEdgesCount(int node)
    {
	return out_edges_count[node];
    }
    int TerminatingEdgesCount(int node)
    {
	return nodes[node]->size()-out_edges_count[node];
    }
};
#endif
