using namespace std;

#include <string>
#include <fpu_control.h>
#include <math.h>
#include <stdio.h>
#include <fstream>
#include "nm.cpp"

int main(int argc, char **argv)
{
    fpu_control_t oldcw, newcw;
    _FPU_GETCW(oldcw); newcw = (oldcw & ~_FPU_EXTENDED) | _FPU_DOUBLE; _FPU_SETCW(newcw);
    Graph *ga, *gb;
    double **apriori_similarity;
    NMSimilarity *s;
    double eps;
    double similarity;
    long *r;
    long *solution;
    if(argc<4) {
      cout << "Two input graphs and an apriori similarity matrix are needed." << endl;
      exit(1);
    }
    if(argc<5)
	eps=0.0001;
    else
	eps=atof(argv[4]);
    
    try
    {
	ga=new Graph(argv[1]);
    }
    catch(...)
    {
	return -1;
    }

    try
    {
	gb=new Graph(argv[2]);
    }
    catch(...)
    {
	return -1;
    }
    
    ifstream in(argv[3]);
    
    int m=ga->NodeCount(),n=gb->NodeCount();
    
    apriori_similarity=new double*[m];
    for(int i=0; i<m; i++)
    {
      apriori_similarity[i]=new double[n];
      for(int j=0; j<n; j++)
        in >> apriori_similarity[i][j];
    }
    
    s=new NMSimilarity(ga,gb,apriori_similarity);

    s->Iterate(eps,100000);
    
    r=(long *)malloc(ga->NodeCount()*gb->NodeCount()*sizeof(long));
    for(int i=0; i<ga->NodeCount(); i++)
	for(int j=0; j<gb->NodeCount(); j++)
	  r[i*gb->NodeCount()+j]=(1-s->NodeSimilarity(i,j))/eps;

    solution=new long[ga->NodeCount()];
    NMSimilarity::hungarian(&r, ga->NodeCount(), gb->NodeCount(), solution, 0);
    
    similarity=0;
    int no=0;
    for(int i=0; i<ga->NodeCount(); i++)
      if(solution[i]>=0)
      {
        similarity+=s->NodeSimilarity(i,solution[i]);
	no++;
      }
    cout << similarity/no << endl;

    /*    
    for(int i=0; i<ga->NodeCount(); i++)
      for(int j=0; j<gb->NodeCount(); j++)
        similarity+=s->NodeSimilarity(i,j);
    
    cout << similarity/(ga->NodeCount()*gb->NodeCount()) << endl;
    */
    
    delete s;
    delete ga;
    delete gb;
    for(int i=0; i<m; i++)
      delete [] apriori_similarity[i];
    delete [] apriori_similarity;
    return 0;
}
