#!/usr/bin/perl
use List::Util qw[min max];

sub decompose
{
  my($s)=$_[0];
  my($sr)="";
  if($s=~/.+=(.+)/)
  {
    $s=$1;
    $sr="= ";
    $s=~s/^[\s]+//g;
  }
  my(@us)=split(" ",$s);
  my($ind)=0;
  if($us[$ind] eq "tail")
  {
    $ind=1;
  }
  my($ins)=$us[$ind];
  my($ss)="";
  my($i);
  if($ins eq "call")
  {
    for($i=$ind; $i<=$#us; $i++)
    {
      if($us[$i]=~/^\@/)
      {
        my($nm)=$us[$i];
        if($nm=~/([^\(]+)\(/)
        {
          $nm=$1;
        }
        $ss=" ".$nm;
        last;
      }
    }
  }
  return $sr.$ins.$ss;
}  

sub blockSimilarity
{
  my($i);
  my($j);
  my(@tmp);  
  my($m);
  my($n);
  my(@b1)=@{$_[0]};
  my(@b2)=@{$_[1]};
  my($x);
  my($y);
  my($z);
  $m=$#b1+2;
  $n=$#b2+2;
  my(@d)=();
  for($i=0; $i<$m; $i++)
  { 
    @tmp=();   
    for($j=0; $j<$n; $j++)
    {
      push(@tmp,0);
    }
    push(@d,[@tmp]);
  }
  
  for($i=0; $i<$m; $i++)
  {
    $d[$i][0]=$i;
  }
  for($i=0; $i<$n; $i++)
  {
    $d[0][$i]=$i;
  }
  
  for($i=1; $i<$m; $i++)
  {
    for($j=1; $j<$n; $j++)
    {
      $x=$d[$i-1][$j]+1;
      $y=$d[$i][$j-1]+1;
      $z=$d[$i-1][$j-1];
      if($b1[$i-1] ne $b2[$j-1])
      {
        $z=$z+1;
      }
      $d[$i][$j]=min($x,$y,$z);
    }
  }
  
  return(1-$d[$m-1][$n-1]/($m+$n-2));
}


sub loadNodes
{
  open(F,$_[0]);
  @nodes=<F>;
  close(F);
  
  
  @fl=();
  $started=0;
  for($i=0; $i<=$#nodes; $i++)
  {
    $t=$nodes[$i];
    if($nodes[$i]=~/^(.+);/)
    {
      $t=$1;
    }
    $t=~s/^[\s]+//g;
    $t=~s/[\s]+$//g;
    if($t eq "")
    {
      next;
    }
    if($t=~/^\d+$/)
    {
      if($started==0)
      {
        $started=1;
      } 
      else
      {
        push(@fl,[@tmpList]);
      }
      @tmpList=();
    } elsif($started==1) {
      $l=decompose($t);
      push(@tmpList,$l);
    }    
  }
  push(@fl,[@tmpList]);
  return @fl;
}


sub similarityMatrix
{
  @n1=loadNodes($_[0]);
  @n2=loadNodes($_[1]);
  open(F,">$_[2]");
  for($i=0; $i<=$#n1; $i++)
  {    
    for($j=0; $j<=$#n2; $j++)
    {
      print F blockSimilarity($n1[$i],$n2[$j]);
      print F " ";
    }
    print F "\n";
  }
  close(F);
}

if($#ARGV!=1)
{
  die("Program needs two arguments.\n");
}

$fn1=$ARGV[0];
$fn2=$ARGV[1];

if(!(-e $fn1.".nod") || !(-e $fn2.".nod"))
{
  die("nod files are missing.");
}

if(!-e $fn1.".cfg" || !-e $fn2.".cfg")
{
  die("cfg files are missing.");
}

similarityMatrix($fn1.".nod",$fn2.".nod","tmpfile.tmp");
open(F,"./nmgraphs $fn1.cfg $fn2.cfg tmpfile.tmp |");
$sim=<F>;
close(F);
unlink("tmpfile.tmp");
chomp $sim;
print "$sim\n";
