#ifndef REGULARARRAY_H
#define REGULARARRAY_H

#include "AbstractArray.h"
#include <iostream>
#include <string>
#include <map>

class RegularArray : public AbstractArray
{
public:
    RegularArray(std::string& name, int adress);
    void print(const std::map<std::string, long>& arrayAddresses, std::ostream &ostr, std::string currentName="", bool isPrintTest=false);
    void addValues(std::string& first, std::string& second);
    void setRight(int rightLimit);
    void setLeft(int leftLimit);
    int getAddress();

    ~RegularArray() {}
private:
    std::string name;
    int address;
    int left;
    int right;
    std::map<std::string, std::string> values;
};

#endif // REGULARARRAY_H
