#include "solvers/solver-interfaces/IregularArray.h"
#include <map>

IregularArray::IregularArray(std::string& index, std::string& value):
    index(index), value(value) {}

void IregularArray::print(const std::map<std::string, long> &arrayAddresses, std::ostream &ostr, std::string currentName, bool isPrintTest){
    if(isPrintTest && !currentName.empty())
        return;
    if(isPrintTest){
        ostr << "IndexOutOfBounds";
        return;
    }

    std::map<std::string, long>::const_iterator arrayAddressesIterator = arrayAddresses.begin();

    ostr << "(";
    for(; arrayAddressesIterator != arrayAddresses.end(); arrayAddressesIterator++) {
        size_t found = arrayAddressesIterator->first.find_last_of("_");
        std::string name = arrayAddressesIterator->first.substr(found+1);
        int position = (std::stoi(index) - 1) / 4;
        ostr << name << "[" << position << "]" << "=" << value;
        if (std::next(arrayAddressesIterator) != arrayAddresses.end())
            ostr << " \\/ ";
    }
    ostr << "), ";
}

