#include "solvers/solver-interfaces/RegularArray.h"
#define ARRAY_ELEMENT_SIZE 4

#include <map>

RegularArray::RegularArray(std::string& name, int address):
    name(name), address(address) {}

void RegularArray::print(const std::map<std::string, long>& arrayAddresses, std::ostream &ostr, std::string currentName, bool isPrintTest){

    if(isPrintTest && this->name != currentName)
        return;

    int length = (left+right) / ARRAY_ELEMENT_SIZE;
    int a = address;

    if(!isPrintTest)
        ostr << name << "[] = { ";

    for(int i=0; i < length ; i++)
    {
        auto found = values.find(std::to_string(a));
        if(found==values.end()){
            if(isPrintTest)
                ostr << 1;
            else
                ostr << "*";
        }
        else {
            std::map<std::string, std::string>::iterator arrayElement = found;
            int index = std::stoi(arrayElement->first);
            if(length >= (index-address)/ARRAY_ELEMENT_SIZE){
                ostr << arrayElement->second;
            }
        }

        if(!isPrintTest && i + 1 != length)
            ostr << ", ";
        else
            ostr << " ";

        a += ARRAY_ELEMENT_SIZE;
    }

    if(!isPrintTest)
        ostr << " }, ";
}

void RegularArray::addValues(std::string& first, std::string& second){
   values.insert(std::pair<std::string, std::string>(first, second));
}

void RegularArray::setLeft(int leftLimit){
    left = leftLimit;
}

void RegularArray::setRight(int rightLimit){
    right = rightLimit;
}

int RegularArray::getAddress(){
    return address;
}
