#!/bin/bash
#script for executing C programs to get potentially unsecured input values using LAV tool
#first argument is C program and it's required
#second argument is theory choose LA or BV corresponding to linear aritmetics or bitvector theory, it's required
#third argument is test folder location and it is optional
#if it doesn't exist test files are generated in Output/test directory in LAV project

#test folder
solver=$1;
program=$2;
test_folder=$3; 

#making test
program_test="${program/.c/_test.c}";
clang -c -g -emit-llvm $program_test;
program_test_o="${program_test/.c/.o}";
if [ -z "$3" ]
then
   $(pwd)/Release+Asserts/bin/LAV $program_test_o -model -solver=Z3-$solver-ARR-EUF -test;
   test_folder="Output/test";
else
   $(pwd)/Release+Asserts/bin/LAV $program_test_o -model -solver=Z3-$solver-ARR-EUF -test -test-folder $test_folder;
fi

#checking test
gcc $program;

for entry in "$test_folder"/*.test
do
  ./a.out < $entry; 
  rc=$?; 
  if [ $rc != 0 ]
  then
	echo "Error status: " $rc;
        echo $var;
  else
       echo 'OK';
  fi
done
