#! /usr/bin/env python
# -*- coding: utf-8 -*-

# python getSmt.py smt_ulaz smt_izlaz 
# ili 
# python getSmt.py smt 
# --> izlaz ce biti smt1 

import sys
import os

# importujemo modul za rad sa regularnim izrazima
import re

#pattern = '[(]declare-fun sqc\d+_([a-z])\n.+\n.+\n'
#pattern1 = '[(]declare-fun sqc\d+_([a-z])\n'

def read_input(path):
    try:
        return open(path, "r") 
    except IOError:
        sys.exit("Failed reading %s" % path)

def open_output(path):
    try:
        return open(path, "w") 
    except IOError:
        sys.exit("Failed reading %s" % path)


lookup = '(check-sat)\n'
help = 'help.smt'

if __name__ == "__main__":
    if len(sys.argv) < 2: sys.exit("usage: ./getSmt.py formula_velika.smt formula_mala.smt")
    smt_in = read_input(sys.argv[1])
    if len(sys.argv) == 2: smt_out = open_output(sys.argv[1]+"out.smt")    
    else: smt_out = open_output(sys.argv[2])
    smt_help = open_output(help)    

    check_sat = []
    for num, line in enumerate(smt_in,1):
        if lookup in line:
            check_sat.append(num)
    smt_in.seek(0);
    #line1 je treci check_sat od pozadi
    #poslednji je check_sat koji nam ne treba, pretposlednji je onaj koji nam treba
    #a od prethodnog pocinjemo prepisivanje formule
    line1 = check_sat[len(check_sat)-3]    
    last_line=check_sat[len(check_sat)-2]

    #preskocimo sve linije pre line1
    for num, line in enumerate(smt_in,1):
        if (num>line1) and (num<=(last_line)):
            smt_help.write(line)
        if (num == last_line - 1):
            smt_help.write("\n;-------------------------------------\n")
            smt_help.write("\n;MIRKO.SMT\n\n")
            smt_help.write("\n;-------------------------------------\n\n")
        if (num == last_line):
            smt_help.write("\n;-------------------------------------\n")
        if (num > last_line):
            smt_help.write(";"+line)

    smt_help.close()
    smt_help = read_input(help).readlines()

    p1 = re.compile("[(]declare-fun (p)?sqc\d+_([a-z])")
    p2 = re.compile("[(]declare-fun (add|sub|mul|sdiv)")
    deklaracije = []
    for line in smt_help:
        if(p1.match(line) or p2.match(line)):
            if line in deklaracije:  
                pass
            else:
                deklaracije.append(line)
                smt_out.write(line)
        else:
            smt_out.write(line)

    smt_out.close()
    os.remove(help)
