%option noyywrap
%option nounput
%{
#include <cstdio>
#include <cstdlib>
#include <string>
#include <vector>
#include "query.hpp"
using namespace std;


#include "parser.tab.hpp"

%}

%%
"between"                     return between_token;
"true"                        return true_token;
"false"                       return false_token;
"select"                      return select_token;
"distinct"                    return distinct_token;
"as"                          return as_token;
"from"                        return from_token;
"where"                       return where_token;
"or"                          return or_token;
"and"                         return and_token;
"not"                         return not_token;
"group"                       return group_token;
"by"                          return by_token;
"having"                      return having_token;
"union"                       return union_token;
"all"                         return all_token;
"except"                      return except_token;
"intersect"                   return intersect_token;
"join"                        return join_token;
"on"                          return on_token;
"in"                          return in_token;
"exists"                      return exists_token;
"into"                        return into_token;
"order by"                    return order_by_token;
"asc"                         return asc_token;
"desc"                        return desc_token;
"limit"                       return limit_token;
"create"                      return create_token;
"view"                        return view_token;
"max"                         return max_token;
"min"                         return min_token;
"avg"                         return avg_token;
"sum"                         return sum_token;
"count"                       return count_token;
[:][a-zA-Z_][a-zA-Z_0-9]*     { yylval.str = new string(yytext); return input_arg_token; }
[a-zA-Z_][a-zA-Z_0-9]*        { yylval.str = new string(yytext); return id_token; }
[0-9]+                        { yylval.n = atoi(yytext); return num_token; }
[*,<>;.()=!+/-]               return *yytext;
[ \n\t]                       { }
.                             {
                                 fprintf(stderr, "Leksicka greska: Nepoznat karakter '%c'\n", *yytext);
                                 exit(EXIT_FAILURE);
                               }
%%
