#!/bin/bash
#argumenti - ime fajla bez ekstenzije i broj ramoztavanja petlje i aritmetika LA ili BV

CFILE="$1.c"
SMTFULLFILE="$1_full.smt"
OFILE="$1.o"
SMTFILE="$1.smt1"
LOOP=$2
ARITMETIKA=$3

function compile {
    echo "clang3.3 -c -g -emit-llvm $CFILE -o $OFILE"
    clang3.3 -c -g -emit-llvm $CFILE -o $OFILE
}

function lav {
    echo "LAV -solver=Z3-$ARITMETIKA-ARR-EUF -Z3-dump-SMT -check-div-zero=false -check-pointers=false --loop-unroll-begin=$LOOP --loop-unroll-end=0 $OFILE 2>$SMTFULLFILE >/dev/null"
    LAV -solver=Z3-$ARITMETIKA-ARR-EUF -Z3-dump-SMT -check-div-zero=false -check-pointers=false --loop-unroll-begin=$LOOP --loop-unroll-end=0 $OFILE 2>$SMTFULLFILE >/dev/null
}

function getSMT {
    echo "python getSmt.py $SMTFULLFILE $SMTFILE"
    python getSmt.py $SMTFULLFILE $SMTFILE
}

function move {
    echo "mv $SMTFILE $ARITMETIKA/$SMTFILE"
    mv $SMTFILE $ARITMETIKA/$SMTFILE
}

function remove {
#    echo "rm $OFILE"
    rm $OFILE
#    echo "rm $SMTFULLFILE"
    rm $SMTFULLFILE
#    echo "rm -r Output"
    rm -r Output
}

function run {
    compile
    lav
    getSMT
#    move
    remove
}

run


