#include "query.hpp"
#include <string>
#include <iostream>
using namespace std;

string n_tabs(unsigned tabs) {
  string t = "";
  for (unsigned i = 0; i < tabs; i++)
    t += "\t";
  return t;
}

#include <sstream>
#include <iomanip>
string number2bitvec(unsigned rank) {
  stringstream stream;
  stream << "#x" << std::setfill ('0') << setw(8) << hex << rank;
  return string(stream.str());
}

#include <set>
extern map<string, set<string> > tables_columns;

bool attributeOf(string a, string t) {
  //TODO: aliases of tables
  return tables_columns[t].count(a);
}

string inputVar2var(string a) {
  return "_" + a.substr(1);
}

string generateCommon(set<string> tables, int max_rank) {
  string result;
  result += "(declare-sort Tabela 0)\n";
  for (auto t : tables)
    result += "(declare-const " + t + " Tabela)\n";
  result += "(declare-sort Red 0)\n";
  //result += "(declare-fun member (Red Tabela) Bool)\n";
  //result += "(declare-fun position (Red) (_ BitVec 32))\n";
  for (unsigned i = 2; i <= tables.size(); i++) {
    string args = "Tabela";
    for (unsigned j = 1; j < i; j++)
      args += " Tabela";
    result += "(declare-fun cross_product" + to_string(i) + " (" + args + ") Tabela)\n";
  }
  if (max_rank >= 0) {
    result += "(declare-sort TRes 0)\n\n";
    result += "(declare-const t_res_0 TRes)\n";
    result += "(declare-const t_res_1 TRes)\n";
  }
  return result;
}

string generateFunctions(set<string> columns, bool la, int max_rank) {
  string result;
  for (auto c : columns)
    if (la == false)
      result += "(declare-fun " + c + " (Red Tabela) (_ BitVec 32))\n";
    else
      result += "(declare-fun " + c + " (Red Tabela) Int)\n";
  if (max_rank >= 0) {
    if (la == false) {
      result += "(declare-fun rank0 (Red TRes) (_ BitVec 32))\n";
      result += "(declare-fun rank1 (Red TRes) (_ BitVec 32))\n";
    }
    else {
      result += "(declare-fun rank0 (Red TRes) Int)\n";
      result += "(declare-fun rank1 (Red TRes) Int)\n";
    }
  }
  return result;
}

string key2formula(string table, set<string> keys, bool la) {
   string result = "(assert (forall ((r1 Red)(r2 Red)";
    for (unsigned i = 0; i < keys.size(); i++)
      if (la == false)
	result += "(x" + to_string(i) + " (_ BitVec 32))";
      else
	result += "(x" + to_string(i) + " Int)";
    result += ")";
    result += "(=> (and ";
    unsigned i;
    i = 0;
    for (auto k : keys)
      result += "(= (" + k + " r1 " + table + ") x" + to_string(i++) + ")";
    i = 0;
    for (auto k : keys)
      result += "(= (" + k + " r2 " + table + ") x" + to_string(i++) + ")";
    result += ") (= r1 r2))";
    result += "))\n";

    return result;
}

string keys2formulas(vector<vector<string> > froms, map<string, set<string> > table_keys, bool la) {
  string result;
  set<string> all;
  for (auto s : froms)
    all.insert(s.begin(), s.end());
  
  for (auto t : table_keys) {
    string table = t.first;
    set<string> keys = t.second;
    if (all.count(table) == 0)
      continue;
    result += key2formula(table, keys, la);
  }

  set<vector<string> > done;
  for (auto v : froms)
    if (v.size() > 1) {
      if (done.count(v))
	continue;
      done.insert(v);
      string tmp = "(cross_product" + to_string(v.size());
      set<string> keys;
      for (auto t : v) {
	tmp += " " + t;
	keys.insert(table_keys[t].begin(), table_keys[t].end());
      }
      tmp += ")";
      result += key2formula(tmp, keys, la);
    }
  
  return result;
}

string keys2formulas1(vector<vector<string> > froms, vector<vector<set<string > > > table_keys_v, vector<string> tts, bool la) {
  string result;
  set<string> all;
  for (auto s : froms)
    all.insert(s.begin(), s.end());
  
  for (unsigned t = 0; t < table_keys_v.size(); t++) {
    string table = tts[t];
    vector<set<string> > keys = table_keys_v[t];
    if (all.count(table) == 0)
      continue;
    for (auto k : keys)
    result += key2formula(table, k, la);
  }

  set<vector<string> > done;
  for (auto v : froms)
    if (v.size() > 1) {
      if (done.count(v))
	continue;
      done.insert(v);
      set<string> keys;
      popuni(result, v, table_keys_v, tts, la, keys, v.size(), 0);
    }
  
  return result;
}

void popuni(string &result, vector<string> v, vector<vector<set<string > > > table_keys_v, vector<string> tts, bool la, set<string> &keys, unsigned n, unsigned k) {
  if (k == n) {
    string tmp = "(cross_product" + to_string(v.size());
    for (auto t : v) {
      tmp += " " + t;
    }
    tmp += ")";
    result += key2formula(tmp, keys, la);
  }
  else {
    unsigned x, i;
    for (i = 0; i < table_keys_v.size(); i++)
      if (v[k] == tts[i]) {
	x = i;
	break;
      }
    if (i == table_keys_v.size()) {
      cerr << "Fali primarni kljuc za tabelu/pogled " + v[k] << endl;
      throw "Fali primarni kljuc za tabelu/pogled " + v[k];
    }
    for (unsigned i = 0; i < table_keys_v[x].size(); i++) {
      keys.insert(table_keys_v[x][i].begin(), table_keys_v[x][i].end());
      popuni(result, v, table_keys_v, tts, la, keys, n, k+1);
      for (auto vvv : table_keys_v[x][i])
	keys.erase(vvv);
    }
  }
}

string cross_product_axioms(vector<vector<string> > froms, vector<set<string> > cols, bool la) {
  string result;
  for(unsigned i = 0; i < froms.size(); i++) {
    vector<string> v = froms[i];
    set<string> c = cols[i];
    if (v.size() > 1) {
      string name;
      for (unsigned j = 0; j < v.size(); j++)
	name += char('a' + j);
      string tmp = "(cross_product" + to_string(v.size());
      for (auto t : v) {
	tmp += " " + t;
      }
      tmp += ")";

      result += "(assert (forall (";
      for (unsigned j = 0; j < c.size(); j++)
	if (la == false)
	  result += "(x" + to_string(j) + " (_ BitVec 32))";
	else
	  result += "(x" + to_string(j) + " Int)";
      result += ")";
      result += "(= (exists ((" + name + " Red)) (and ";
      unsigned jj = 0;
      for (auto cc : c) {
	result += "(= (";
	result += cc + " " + name + " " + tmp + ") x" + to_string(jj++) +")";
      }
      result += ")) ";
      result += "(exists (";
      for (unsigned j = 0; j < v.size(); j++) 
	result += string("(") + char('a' + j) + " Red)";
      result += ") (and ";
      jj = 0;
      for (auto cc : c) {
	result += "(= (";
	string ttt;
	try {
	  ttt = prefix2table(cc);
	}
	catch (string s) {
	  cerr << s << endl;
	  exit(EXIT_FAILURE);
	}
	unsigned kk = 0;
	for (kk = 0; kk < v.size(); kk++)
	  if (v[kk] == ttt)
	    break;
	result += cc + " " + char('a' + kk) + " " + ttt + ") x" + to_string(jj++) +")";
      }
      result += ")))";
      result += "))\n";
    }
  }
  return result;
}

string prefix2table(string x) {
  if (x.substr(0, string("City_").size() - 1) == string("City"))
    return "Cities";
  if (x.substr(0, string("Country_").size() - 1) == string("Country"))
    return "Countries";
  if (x.substr(0, string("Continent_").size() - 1) == string("Continent"))
    return "Continents";
  if (x.substr(0, string("Passport_").size() - 1) == string("Passport"))
    return "Passports";
  if (x.substr(0, string("Person_").size() - 1) == string("Person"))
    return "Persons";
  if (x.substr(0, string("Persol_").size() - 1) == string("Persol"))
    return "Persols";
  if (x.substr(0, string("Post_").size() - 1) == string("Post"))
    return "Posts";
  if (x == "e_emp_id" || x == "e_end_date" || x == "e_start_date" || x == "s_superior_emp_id")
    return "employee";
  if (x == "t_txn_id" || x == "t_amount" || x == "t_account_id")
    return "transaction";
  if (x == "a_account_id" || x == "a_avail_balance" || x == "a_cust_id")
    return "account";
  if (x == "c_cust_id")
    return "customer";
  if (x == "i_cust_id" || x == "i_lname" || x == "i_fname")
    return "individual";
  throw "The column " + x + " should be prefixed with table name";
}

string froms2table(vector<string> froms) {
  string table;
  if (froms.size() == 1)
    table = froms[0];
  else {
    table = "(cross_product" + to_string(froms.size());
    for (auto f : froms)
      table += " " + f;
    table += ")";
  }
  return table;
}

string c_function_declaration(string fn_name, unsigned len) {
  string result = "int " + fn_name + "(";
  for (unsigned jjj = 0; jjj < len; jjj++) {
    if (jjj != 0)
      result += ", ";
    result += "int";
  }
  result += ");";
  return result;
}

string add_rank(string v, int jj) {
  if (jj < 0)
    return v;
  unsigned index = v.rfind("_sqc");
  return v.substr(0, index) + "_" + to_string(jj) + "_sqc";
}

bool compareExpression(Expression* e1, Expression* e2) {
  map<string, string> cs;
  return e1->toFormula(cs, true) < e2->toFormula(cs, true);
}

bool True::equal(Expression *e) const {
  True *v = dynamic_cast<True*>(e);
  if (v)
    return true;
  else
    return false;
}

bool False::equal(Expression *e) const {
  False *v = dynamic_cast<False*>(e);
  if (v)
    return true;
  else
    return false;
}

bool Var::equal(Expression *e) const {
  Var *v = dynamic_cast<Var*>(e);
  if (v) {
    unsigned i = _s.find_first_of(".");
    if (i == string::npos)
      i = -1;
    string s1 = _s.substr(i+1);
    i = v->_s.find_first_of(".");
    if (i == string::npos)
      i = -1;
    string s2 = v->_s.substr(i+1);
    return s1 == s2;
  }
  return false;
}

bool Num::equal(Expression *e) const {
  Num *v = dynamic_cast<Num*>(e);
  if (v && _broj == v->_broj)
    return true;
  else
    return false;
}

bool BinaryOperator::equal(Expression *e) const {
  {
    auto *a1 = dynamic_cast<const Greater*>(e);
    auto *a2 = dynamic_cast<const Greater*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const Less*>(e);
    auto *a2 = dynamic_cast<const Less*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const GreaterEq*>(e);
    auto *a2 = dynamic_cast<const GreaterEq*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const LessEq*>(e);
    auto *a2 = dynamic_cast<const LessEq*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const Eq*>(e);
    auto *a2 = dynamic_cast<const Eq*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const Dis*>(e);
    auto *a2 = dynamic_cast<const Dis*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const Or*>(e);
    auto *a2 = dynamic_cast<const Or*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const And*>(e);
    auto *a2 = dynamic_cast<const And*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const Add*>(e);
    auto *a2 = dynamic_cast<const Add*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const Sub*>(e);
    auto *a2 = dynamic_cast<const Sub*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const Mul*>(e);
    auto *a2 = dynamic_cast<const Mul*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
  {
    auto *a1 = dynamic_cast<const Div*>(e);
    auto *a2 = dynamic_cast<const Div*>(this);
    if (a1 && a2 && a1->_first->equal(a2->_first) && a1->_second->equal(a2->_second))
      return true;
  }
    
  return false;
}

bool BinaryOperator::isConst() const {
  return _first->isConst() && _second->isConst();
}

bool UnaryOperator::equal(Expression *e) const {
  //TODO:
  return false;
}

bool UnaryOperator::isConst() const {
  return _first->isConst();
}

bool Exists::equal(Expression *e) const {
  //TODO:
  return false;
}

string Var::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  bool tmp = false;
  for (auto t : tables)
    if (attributeOf(_s, t))
      tmp = true;
  if (tmp)
    return _s + "(" +varname + ")";
  else
    return _s + "(W)";
}

vector<string> Var::differentVars() const {
  vector<string> tmp;
  tmp.push_back(_s);
  return tmp;
}

string Var::toFormula(map<string, string> cs, bool la) const {
  auto tmp = cs.find(_s);
  if (tmp != cs.end())
    return tmp->second;
  else
    return _s;
  //  throw "Ovo ne sme da se desi";
}

string Num::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return to_string(_broj);
}

vector<string> BinaryOperator::differentVars() const {
  vector<string> a = _first->differentVars();
  vector<string> b = _second->differentVars();
  a.insert(a.end(), b.begin(), b.end());
  return a;
}

vector<string> BinaryOperator::differentInputs() const {
  vector<string> a = _first->differentInputs();
  vector<string> b = _second->differentInputs();
  a.insert(a.end(), b.begin(), b.end());
  return a;
}

string Less::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return n_tabs(tabs) + "$less(" + _first->translate(0, varname, tables) + "," +  _second->translate(0, varname, tables) + ")";
}

string Greater::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return n_tabs(tabs) + "$greater(" + _first->translate(0, varname, tables) + "," +  _second->translate(0, varname, tables) + ")";
}

string LessEq::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return n_tabs(tabs) + "$lesseq(" + _first->translate(0, varname, tables) + "," +  _second->translate(0, varname, tables) + ")";
}

string GreaterEq::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return n_tabs(tabs) + "$greatereq(" + _first->translate(0, varname, tables) + "," +  _second->translate(0, varname, tables) + ")";
}

string Eq::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return n_tabs(tabs) + _first->translate(tabs, varname, tables) + " = " +  _second->translate(tabs, varname, tables);
}

string Dis::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return n_tabs(tabs) + _first->translate(tabs, varname, tables) + " != " +  _second->translate(tabs, varname, tables);
}

string Or::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return _first->translate(tabs, varname, tables) + " | \n" +  _second->translate(tabs, varname, tables);
}

string And::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return _first->translate(tabs, varname, tables) + " & \n" +  _second->translate(tabs, varname, tables);
}

string Add::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  //return _first->translate(tabs, varname, tables) + " + " +  _second->translate(tabs, varname, tables);
  return "TODO";
}

string Sub::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  //return _first->translate(tabs, varname, tables) + " - " +  _second->translate(tabs, varname, tables);
  return "TODO";
}

string Mul::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  //return _first->translate(tabs, varname, tables) + " * " +  _second->translate(tabs, varname, tables);
  return "TODO";
}

string Div::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  //return _first->translate(tabs, varname, tables) + " / " +  _second->translate(tabs, varname, tables);
  return "TODO";
}

string Add::toFormula(map<string, string> cs, bool la) const {
  string fn_name = (la == false ? "bvadd" : "+");
  return "(" + fn_name + " " + _first->toFormula(cs, la) + " " + _second->toFormula(cs, la) + ")";
}

string Sub::toFormula(map<string, string> cs, bool la) const {
  string fn_name = (la == false ? "bvsub" : "-");
  return "(" + fn_name + " " + _first->toFormula(cs, la) + " " + _second->toFormula(cs, la) + ")";
}

string Mul::toFormula(map<string, string> cs, bool la) const {
  string fn_name = (la == false ? "bvmul" : "*");
  //string fn_name = (la == false ? "bvmul" : "mul");
  return "(" + fn_name + " " + _first->toFormula(cs, la) + " " + _second->toFormula(cs, la) + ")";
}

string Div::toFormula(map<string, string> cs, bool la) const {
  string fn_name = (la == false ? "bvsdiv" : "/");
  //string fn_name = (la == false ? "bvsdiv" : "sdiv");
  return "(" + fn_name + " " + _first->toFormula(cs, la) + " " + _second->toFormula(cs, la) + ")";
}

vector<string> UnaryOperator::differentVars() const {
  return _first->differentVars();
}

vector<string> UnaryOperator::differentInputs() const {
  return _first->differentInputs();
}

string Not::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return n_tabs(tabs) + "~ (\n" + _first->translate(tabs+1, varname, tables) + "\n" + n_tabs(tabs) + ")";
}

string Function::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  //TODO:
  return "TODO";
}

string Group::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  return n_tabs(tabs) + "(\n" + _first->translate(tabs+1, varname, tables) + "\n" + n_tabs(tabs) + ")";
}

Exists::~Exists() {
  delete _q;
}

string Exists::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  string r = n_tabs(tabs) + "? [Y] : (\n";
  if (_q->isCorellated())
    if (cardinality == false)
      r += n_tabs(tabs+1) + "memberT(Y, tmp" + to_string(_i) + ", " + varname + ")";
    else
      r += n_tabs(tabs+1) + "memberT(Y, tmp" + to_string(_i) + ", W)";
  else
    r += n_tabs(tabs+1) + "member(Y, tmp" + to_string(_i) + ")";
  r += "\n" + n_tabs(tabs) + ")";
  return r;
}

string In::translate(unsigned tabs, string varname, vector<string> tables, bool cardinality) const {
  string r = n_tabs(tabs) + "? [Y] : (\n";
  if (_q->isCorellated())
    if (cardinality == false)
      r += n_tabs(tabs+1) + "memberT(Y, tmp" + to_string(_i) + ", " + varname + ") &\n";
    else
      r += n_tabs(tabs+1) + "memberT(Y, tmp" + to_string(_i) + ", W) &\n";
  else
    r += n_tabs(tabs+1) + "member(Y, tmp" + to_string(_i) + ") &\n";
  if (_s != "")
    if (cardinality == false)
      r += n_tabs(tabs+1) + _s + "(" + varname + ") = " + _q->getFirstSelectionString() + "(Y)";
    else
      r += n_tabs(tabs+1) + _s + "(W) = " + _q->getFirstSelectionString() + "(Y)";
  else
    r += n_tabs(tabs+1) + to_string(_num) + " = " + _q->getFirstSelectionString() + "(Y)";
  r += "\n" + n_tabs(tabs) + ")";
  return r;
}

unsigned Query::_total = 0;

string Query::translate(unsigned tabs, bool cardinality) const {
  string t = n_tabs(tabs);
  string r = t;
  if (_selections.size() != 0 && cardinality == false) {
    t = n_tabs(tabs+1);
    r += "? [X] : (\n" + t;
    if (_froms.size() == 1)
      r += "member(X, " + _froms[0] + ")";
    else {
      r += "member(X, cross_product(";
      for (unsigned i = 0; i < _froms.size() - 1; i++)
	r += _froms[i] + ", ";
      r += _froms.back() + "))";
    }
  }
  else {
    if (_froms.size() == 1)
      r += "member(Elem, " + _froms[0] + ")";
    else {
      r += "member(Elem, cross_product(";
      for (unsigned i = 0; i < _froms.size() - 1; i++)
	r += _froms[i] + ", ";
      r += _froms.back() + "))";
    }
  }
  for (unsigned j = 0; j < _selections.size(); j++) {
    r += string(" & ") + "\n" + t;
    if (cardinality == false)
      r += _selections[j]->getSelectionString() + "(X) = " + _selections[j]->getSelectionString() + "(Elem)";
    else
      r += _selections[j]->getSelectionString() + "(Elem) = " + _selections[j]->getSelectionString() + "(W)";
  }
  if (cardinality == true && _selections.size() == 0) {
    for (auto t1 : _froms)
      for (auto c : tables_columns[t1]) {
	r += string(" & ") + "\n" + t;
	r += c + "(Elem) = " + c + "(W)";
      }
  }
  if (_where) {
    r += string(" & ") + "\n" + t + "(\n";
    if (_selections.size() != 0  && cardinality == false)
      r += _where->translate(tabs + 2, "X", _froms, cardinality);
    else
      r += _where->translate(tabs + 1, "Elem", _froms, cardinality);
    r += "\n" + t + ")";
  }
  if (_selections.size() != 0 && cardinality == false)
    r += "\n" + n_tabs(tabs) + ")";
  return r;
}

bool Query::isCorellated() const {
  return _where->isCorellated(_froms);
}

string Union::translate(unsigned tabs, bool cardinality) const {
  string t = n_tabs(tabs);
  string r = t + "(\n" + _q1->translate(tabs+1, cardinality) + "\n" + t + ")\n";
  r += t + "|\n";
  r += t + "(\n" + _q2->translate(tabs+1, cardinality) + "\n" + t + ")\n";
  return r;
}

string Except::translate(unsigned tabs, bool cardinality) const {
  string t = n_tabs(tabs);
  string r = t + "(\n" + _q1->translate(tabs+1, cardinality) + "\n" + t + ")\n";
  r += t + "&\n";
  r += t + "~(\n" + _q2->translate(tabs+1, cardinality) + "\n" + t + ")\n";
  return r;
}

string Intersect::translate(unsigned tabs, bool cardinality) const {
  string t = n_tabs(tabs);
  string r = t + "(\n" + _q1->translate(tabs+1, cardinality) + "\n" + t + ")\n";
  r += t + "&\n";
  r += t + "(\n" + _q2->translate(tabs+1, cardinality) + "\n" + t + ")\n";
  return r;
}

//------------------------ LAV --------------------------------------

string True::lav_exists(string table, int rank, bool la) const {
  return "true ";
}

string False::lav_exists(string table, int rank, bool la) const {
  return "TODO";
  //return "0";
}

string projection2fn(string x, string table) {
  unsigned i = x.find_first_of(".");
  if (i == string::npos)
    i = -1;
  return "(" + x.substr(i+1) + " r " + table + ")";  
}

string removePrefix(string x) {
  unsigned i = x.find_first_of(".");
  if (i == string::npos) {
    cerr << "Alijasi su obavezni" << endl;
    exit(EXIT_FAILURE);
  }
  return x.substr(i+1);  
}


string Var::lav_exists(string table, int rank, bool la) const {
  return projection2fn(_s, table);
}

string InputVar::lav_exists(string table, int rank, bool la) const {
  if (rank < 0)
    return inputVar2var(_s);
  else
    return add_rank(inputVar2var(_s), rank);
}

string Num::lav_exists(string table, int rank, bool la) const {
  if (la)
    return to_string(_broj) + " ";
  else
    return number2bitvec(_broj) + " ";
}

string In::lav_exists(string table, int rank, bool la) const {
  return "TODO";
}

string Exists::lav_exists(string table, int rank, bool la) const {
  return "TODO";
}

string Group::lav_exists(string table, int rank, bool la) const {
  return _first->lav_exists(table, rank, la);
}

string Not::lav_exists(string table, int rank, bool la) const {
  return "(not " + _first->lav_exists(table, rank, la) + ")";
}

string Function::lav_exists(string table, int rank, bool la) const {
  return "(" + _name + " " + _first->lav_exists(table, rank, la) + ")";
}

unsigned AggFunction::_total = 0;
map<string, unsigned> fresh_new_hash;
AggFunction::AggFunction(string name, Expression *first, bool disabled)
  :Function(name, first), _fresh_new(_total++), _disabled(disabled)
{
  map<string, string> cs;
  string tmp = _first->toFormula(cs, true);
  auto i = fresh_new_hash.find(tmp);
  if (i != fresh_new_hash.end()) {
    _fresh_new = i->second;
    _total--;
  }
  else
    fresh_new_hash[tmp] = _fresh_new;
}

string AggFunction::lav_exists(string table, int rank, bool la) const {
  /*
  vector<Expression*> v;
  string orig = _first->lav_exists(table, rank, la);
  orig = orig.substr(1, orig.find_first_of(" ") -  1);
  if (agg_columns.find(orig) == agg_columns.end()) {
    agg_columns[orig] = agg_columns_no++;
  }
  for (auto g : _groups)
    v.push_back(_first->substitute(orig, g));
  string tmp = "";
  for (auto x : v)
    tmp += x->lav_exists(table, rank, la) + " ";
  */
  if (_disabled == false) {
    return "(" + _name + " groupby_" + to_string(_q_id) + " fresh_new_" + to_string(_fresh_new) + ")";
  }
  else {
    return _first->lav_exists(table, rank, la);
  }
}

string AggFunction::toFormula(map<string, string> cs, bool la) const {
  /*
  string frml = _first->toFormula(cs, la);
  string orig = frml.substr(1, frml.find_first_of(" ") -  1);
  if (agg_columns.find(orig) == agg_columns.end()) {
    agg_columns[orig] = agg_columns_no++;
  }
  vector<string> vs;
  for (auto g : _groups) {
    vs.push_back(g->toFormula(cs, la));
  }
  string tmp = "";
  for (auto x : vs) {
    string frml1 = frml;
    unsigned index = frml1.find(orig);
    frml1.replace(index, orig.size(), x);
    tmp += frml1 + " ";
  }
  return "(" + _name + " " + to_string(agg_columns[orig]) + " " + tmp + ")";
  */
  //return "(" + _name + " " + _first->toFormula(cs, la) + ")";
  if (_disabled == false) {
    return "(" + _name + " groupby_" + to_string(_q_id) + " fresh_new_" + to_string(_fresh_new) + ")";
  }
  else {
    return _first->toFormula(cs, la);
  }
}

string And::lav_exists(string table, int rank, bool la) const {
  return "(and " + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string Or::lav_exists(string table, int rank, bool la) const {
  return "(or " + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string Dis::lav_exists(string table, int rank, bool la) const {
  return "(not (= " + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + "))";
}

string Eq::lav_exists(string table, int rank, bool la) const {
  return "(= " + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string GreaterEq::lav_exists(string table, int rank, bool la) const {
  return (la ? "(>= " : "(bvuge ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string LessEq::lav_exists(string table, int rank, bool la) const {
  return (la ? "(<= " : "(bvule ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string Greater::lav_exists(string table, int rank, bool la) const {
  return (la ? "(> " : "(bvugt ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string Less::lav_exists(string table, int rank, bool la) const {
  return (la ? "(< " : "(bvult ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string Add::lav_exists(string table, int rank, bool la) const {
  return (la ? "(+ " : "(bvadd ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string Sub::lav_exists(string table, int rank, bool la) const {
  return (la ? "(- " : "(bvsub ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string Mul::lav_exists(string table, int rank, bool la) const {
  return (la ? "(* " : "(bvmul ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
  //return (la ? "(mul " : "(bvmul ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string Div::lav_exists(string table, int rank, bool la) const {
  return (la ? "(/ " : "(bvsdiv ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
  //return (la ? "(sdiv " : "(bvsdiv ") + _first->lav_exists(table, rank, la) + " " + _second->lav_exists(table, rank, la) + ")";
}

string Intersect::lav_predicate_feature(bool la, int max_rank) const {
  return "TODO";
}

string Intersect::lav_unique_existence(bool c, bool la) const {
  return "TODO";
}

string Intersect::lav_existence(bool c, bool la, int rank) const {
  return "TODO";
}

string Intersect::lav_result(bool c, bool la, int rank) const {
  return "TODO";
}

void Intersect::preproccess(map<string, vector<string> > table_columns, vector<vector<set<string> > > table_keys_v) {
  return;
}

string Intersect::lav_position(bool la, int rank) const {
  return "TODO";
}

string Except::lav_predicate_feature(bool la, int max_rank) const {
  return "TODO";
}

string Except::lav_unique_existence(bool c, bool la) const {
  return "TODO";
}

string Except::lav_existence(bool c, bool la, int rank) const {
  return "TODO";
}

string Except::lav_result(bool c, bool la, int rank) const {
  return "TODO";
}

void Except::preproccess(map<string, vector<string> > table_columns, vector<vector<set<string> > > table_keys_v) {
  return;
}

string Except::lav_position(bool la, int rank) const {
  return "TODO";
}

string Union::lav_predicate_feature(bool la, int max_rank) const {
  return "TODO";
}

string Union::lav_unique_existence(bool c, bool la) const {
  return "TODO";
}

string Union::lav_existence(bool c, bool la, int rank) const {
  return "TODO";
}

string Union::lav_result(bool c, bool la, int rank) const {
  return "TODO";
}

void Union::preproccess(map<string, vector<string> > table_columns, vector<vector<set<string> > > table_keys_v) {
  return;
}

string Union::lav_position(bool la, int rank) const {
  return "TODO";
}

string Query::lav_predicate_feature(bool la, int max_rank) const {
  string result;
  vector<string> arg_names = differentInputs();
  string fn_name = "psqc" + to_string(max_rank >= 0 ? arg_names.size() + 1 : arg_names.size()) + "_" + string(1, 'a' + _id);

  bool cursors = true;
  if (max_rank < 0) {
    cursors = false;
    max_rank = 0;
  }
  for (int rr = 0; rr <= max_rank; rr++) {
    result += "(assert ";
    result += "(or";
    if (la == false)
      result += " (= (" + fn_name + (cursors ? " " + number2bitvec(rr) : "");
    else
      result += " (= (" + fn_name + (cursors ? " " + to_string(rr) : "");
    for (unsigned i = 0; i < arg_names.size(); i++)
      if (cursors)
	result += " " + add_rank(inputVar2var(arg_names[i]), rr);
      else
	result += " " + inputVar2var(arg_names[i]);
    if (la == false) {
      result += ") #x00000000)";
    }
    else {
      result += ") 0)";
    }
    if (la == false)
      result += " (= (" + fn_name + (cursors ? " " + number2bitvec(rr) : "");
    else
      result += " (= (" + fn_name + (cursors ? " " + to_string(rr) : "");
    for (unsigned i = 0; i < arg_names.size(); i++)
      if (cursors)
	result += " " + add_rank(inputVar2var(arg_names[i]), rr);
      else
	result += " " + inputVar2var(arg_names[i]);
    if (la == false)
      result += ") #x00000001)";
    else
      result += ") 1)";
    result += "))\n";
  }
  return result;
}

#include <regex>
string Query::lav_unique_existence(bool c, bool la) const {  
  vector<string> arg_names = differentInputs();
  for (unsigned i = 0; i < arg_names.size(); i++)
    arg_names[i] = inputVar2var(arg_names[i]);
  string fn_name = "psqc" + to_string(arg_names.size()) + "_" + string(1, 'a' + _id);

  if (c == true) {
    string r = "success_" + string(1, 'a' + _id) + " = " + fn_name + "(";
    bool first = true;
    for (auto a : arg_names) {
      if (!first)
	r += ", ";
      r += inputVar2var(a).substr(1);
      first = false;
    }
    r += ");\n";
    return r;
  }
  
  string result;
  result += "(assert ";
  result += "(= (= (" + fn_name;
  for (auto a : arg_names)
    result += " " + inputVar2var(a);
  if (la == false)
    result += ") #x00000001)";
  else
    result += ") 1)";
  
  result += " (and";
  result += " (exists ((r Red))";
  string table = froms2table(_froms);
  result += _where->lav_exists(table);
  result += ")";
  regex reg(" r");
  result += " (forall ((r1 Red)(r2 Red)) (=> (and ";
  result += regex_replace(_where->lav_exists(table), reg, " r1");
  result += regex_replace(_where->lav_exists(table), reg, " r2");
  result += ")";
  result += "(= r1 r2)))";
  result += ")))\n";
  
  return result;
}

string Query::lav_existence(bool c, bool la, int rank) const {
  vector<string> arg_names = differentInputs();
  string fn_name = "psqc" + to_string(arg_names.size()+1) + "_" + string(1, 'a' + _id);

  if (c == true) {
    // TODO:  Ova promenljiva i je hardkodirana
    string r = "success_" + string(1, 'a' + _id) + "[i] = " + fn_name + "(i";
    for (auto a : arg_names) {
      r += ", " + inputVar2var(a).substr(1);
    }
    r += ");\n";
    return r;
  }

  for (unsigned i = 0; i < arg_names.size(); i++)
    arg_names[i] = add_rank(inputVar2var(arg_names[i]), rank);
  
  string result;
  result += "(assert ";
  result += "(=> ";
  if (la == false)
    result += "(bvsge " + number2bitvec(rank) + " #x00000000) ";
  else
    result += "(>= " + to_string(rank) + " 0) ";
  result += "(= (= (" + fn_name + " ";
  if (la == false)
    result += number2bitvec(rank);
  else
    result += to_string(rank);
  for (auto a : arg_names)
    result += " " + inputVar2var(a);
  result += ") ";
  if (la == false)
    result += "#x00000001";
  else
    result += "1";
  result += ")";
  
  result += " (exists ((r Red))";
  result += "(= (rank" + to_string(_id) + " r t_res_" + to_string(_id) + ") ";
  if (la == false)
    result += number2bitvec(rank);
  else
    result += to_string(rank);
  result += ")";
  result += "))))\n";
  
  return result;
}

string position_criteria_equality(Query *q1, Query *q2, bool la, int rank) {
  string result;
  
  result += "(assert (forall ((r1 Red)(r2 Red)";
  result += ") ";

  result += "(=> ";

  if (la == false)
    result += "(bvsge " + number2bitvec(rank) + " #x00000000) ";
  else
    result += "(>= " + to_string(rank) + " 0) ";
  
  result += "(=> (and ";

  string table = froms2table(q1->vectables());
  regex reg(" r");
  
  result += "(= (rank0 r1 t_res_0) ";
  if (la == false)
    result += number2bitvec(rank);
  else
    result += to_string(rank);
  result += ")";
  
  result += "(= (rank1 r2 t_res_1) ";
  if (la == false)
    result += number2bitvec(rank);
  else
    result += to_string(rank);
  result += ")";
  
  result += ")";
  
  result += "(and ";
  
  vector<vector<string> > diffVars1;
  vector<vector<string> > diffVars2;

  // q1 or q2; it should be the same
  if (q2->getOrderBy().size() == 0)
    result += "true";
  if (q1->getOrderBy().size() == q2->getOrderBy().size()) {
    for (unsigned proj = 0; proj < q1->getOrderBy().size(); proj++) {
      diffVars1.push_back(q1->getOrderBy()[proj].first->differentVars());
      diffVars2.push_back(q2->getOrderBy()[proj].first->differentVars());
    }
    for (unsigned proj = 0; proj < q1->getOrderBy().size(); proj++) {
      map<string, string> cs1;
      map<string, string> cs2;
      for (unsigned jj = 0; jj < diffVars1[proj].size(); jj++)
	cs1[diffVars1[proj][jj]] = projection2fn(diffVars1[proj][jj], table);
      for (unsigned jj = 0; jj < diffVars2[proj].size(); jj++)
	cs2[diffVars2[proj][jj]] = projection2fn(diffVars2[proj][jj], table);
      string tmp1 = q1->getOrderBy()[proj].first->toFormula(cs1, la);
      result += "(= " + regex_replace(tmp1, reg, " r1") + " " + regex_replace(tmp1, reg, " r2") + ")";
      string tmp2 = q2->getOrderBy()[proj].first->toFormula(cs2, la);
      result += "(= " + regex_replace(tmp2, reg, " r1") + " " + regex_replace(tmp2, reg, " r2") + ")";
    }
  }
  
  result += ")";
  result += "))))\n";

  return result;
}

string position_range(Query *q1, Query *q2, bool la, int rank) {
  string result;
  
  result += "(assert ";
  result += "(=> ";

  if (la == false)
    result += "(bvsge " + number2bitvec(rank) + " #x00000000) ";
  else
    result += "(>= " + to_string(rank) + " 0) ";
  
  result += "(= ";

  result += "(exists ((r Red))";
  result += "(= (rank0 r t_res_0) ";
  if (la == false)
    result += number2bitvec(rank);
  else
    result += to_string(rank);
  result += ")";
  result += ")";

  result += "(exists ((r Red))";
  result += "(= (rank1 r t_res_1) ";
  if (la == false)
    result += number2bitvec(rank);
  else
    result += to_string(rank);
  result += ")";
  result += ")";
  
  result += ")))";

  return result;
}

string Query::lav_result(bool c, bool la, int rank) const {
  string result;
  vector<string> arg_names = differentInputs();
  for (unsigned i = 0; i < arg_names.size(); i++)
    arg_names[i] = inputVar2var(arg_names[i]);
  bool cursors = rank >= 0;
  string fn_name = "sqc" + to_string(cursors ? arg_names.size() + 2 : arg_names.size() + 1) + "_" + string(1, 'a' + _id);
  string p_name = "psqc" + to_string(cursors ? arg_names.size() + 1 : arg_names.size() + 0) + "_" + string(1, 'a' + _id);
  
  if (c == true) {
    string r;
    for (unsigned proj = 0; proj < _selections.size(); proj++) {
      string rrr = inputVar2var(_intos[proj]).substr(1);
      //TODO: Ova promenljiva i je hardkodirana
      r += rrr + " = " + fn_name + "(" + (cursors ? "i, " : "") + to_string(proj);
      for (auto a : arg_names)
	r += ", " + inputVar2var(a).substr(1);
      r += ");\n";
    }
    return r;      
  }
  
  vector<bool> isExpression;
  vector<vector<string> > diffVars;
  vector<string> rrr;
  
  for (unsigned proj = 0; proj < _selections.size(); proj++) {
    isExpression.push_back(_selections[proj]->isExpression());
    diffVars.push_back(_selections[proj]->differentVars());
    rrr.push_back(inputVar2var(_intos[proj]));
  }
    
  result += "(assert ";
  result += "(=> ";
  result += "(and ";

  if (cursors) {
    if (la == false)
      result += "(bvsge " + number2bitvec(rank) + " #x00000000) ";
    else
      result += "(>= " + to_string(rank) + " 0) ";
  }
    
  result += "(= (";
  if (la == false)
    result += p_name + (cursors ? " " + number2bitvec(rank) : "");
  else
    result += p_name + (cursors ? " " + to_string(rank) : ""); 
  for (auto a : arg_names)
    result += " " + add_rank(inputVar2var(a), rank);
  result += ") ";
  if (la == false)
    result += "#x00000001";
  else
    result += "1";
  result += ")";
  for (unsigned proj = 0; proj < _selections.size(); proj++) {
    result += "(= (";
    if (la == false)
      result += fn_name + " " + (cursors ? number2bitvec(rank) + " " : "") + number2bitvec(proj);
    else
      result += fn_name + " " + (cursors ? to_string(rank) + " " : "") + to_string(proj); 
    for (auto a : arg_names)
      result += " " + add_rank(inputVar2var(a), rank);
    result += ") " + add_rank(rrr[proj], rank) + ")";
  }
  result += ") ";

  result += "(exists ((r Red)";
  unsigned tt = 0;
  for (unsigned proj = 0; proj < _selections.size(); proj++) {
    if (isExpression[proj]) {
      for (unsigned jjj = 0; jjj < diffVars[proj].size(); jjj++)
	if (la == false)
	  result += "(c" + to_string(tt + jjj) + " (_  BitVec 32))";
	else
	  result += "(c" + to_string(tt + jjj) + " Int)";
      tt += diffVars[proj].size();
    }
  }
  result += ")";

  result += "(and ";  
  string table = froms2table(_froms);
  if (rank < 0)
    result += _where->lav_exists(table, rank, la);
  if (rank >= 0) {
    result += "(= (rank" + to_string(_id) + " r t_res_" + to_string(_id) + ") ";
    if (la == false)
      result += number2bitvec(rank);
    else
      result += to_string(rank);
    result += ")";
  }
  
  tt = 0;
  for (unsigned proj = 0; proj < _selections.size(); proj++) {
    if (_selections[proj]->getExpression()->isConst()) {
      map<string, string> cs;
      result += "(= " + _selections[proj]->toFormula(cs, la) + " " + add_rank(rrr[proj], rank) + ")";
    }
    else if (!isExpression[proj]) {
      //TODO: Check this!
      //result += "(= " + projection2fn(_selections[proj]->getSelectionString(), table) + " " + add_rank(rrr[proj], rank) + ")";
      result += "(= " + _selections[proj]->getExpression()->lav_exists(table, rank, la) + " " + add_rank(rrr[proj], rank) + ")";
    }
    else {
      for (unsigned jj = 0; jj < diffVars[proj].size(); jj++)
	result += "(= " + projection2fn(diffVars[proj][jj], table) + " c" + to_string(tt + jj) + ")";
      tt += diffVars[proj].size();
    }
  }

  tt = 0;
  for (unsigned proj = 0; proj < _selections.size(); proj++) {
    if (isExpression[proj]) {
      map<string, string> cs;
      for (unsigned jj = 0; jj < diffVars[proj].size(); jj++)
	cs[diffVars[proj][jj]] = "c" + to_string(tt + jj);
      vector<string> diffInputs = _selections[proj]->getExpression()->differentInputs();
      for (auto aaa : diffInputs) {
	string bbb = add_rank(aaa, rank);
	bbb[0] = '_';
	cs[aaa] = bbb;
      }
      tt += diffVars[proj].size();
      result += "(= " + add_rank(rrr[proj], rank) + " " + _selections[proj]->toFormula(cs, la) + ")";
    }
  }
  result += "))";
  result += "))\n";

  
  return result;
}

bool Query::isGroupByPK(map<string, set<set<string> > > table_keys) const {
  unsigned q = 0;
  for (auto f : _froms) {
    for (auto x : table_keys[f]) {
      bool tt = true;
      for (auto y : x) {
	Var v(y);
	bool tmp = false;
	for (auto i : _groups) {
	  if (v.equal(i)) {
	    tmp = true;
	    break;
	  }
	}
	if (tmp == false) {
	  tt = false;
	  break;
	}
      }
      if (tt == true) {
	q++;
	break;
      }
    }
  }
  
  if (q == _froms.size())
    return true;

  return false;
}

bool Query::isCompleteOrderByPK(map<string, set<set<string> > > table_keys) const {
  unsigned q = 0;
  for (auto f : _froms) {
    for (auto x : table_keys[f]) {
      bool tt = true;
      for (auto y : x) {
	Var v(y);
	bool tmp = false;
	for (auto i : _crts) {
	  auto e = i.first;
	  if (v.equal(e)) {
	    tmp = true;
	    break;
	  }
	}
	if (tmp == false) {
	  tt = false;
	  break;
	}
      }
      if (tt == true) {
	q++;
	break;
      }
    }
  }
  
  if (q == _froms.size())
    return true;

  return false;
}

bool Query::isCompleteOrder(map<string, set<set<string> > > table_keys) const {
  bool res = isCompleteOrderByPK(table_keys);
  if (res)
    return res;
  
  for (auto s : _selections) {    
    bool tmp = false;
    for (auto i : _crts) {
      auto e = i.first;
      if (s->getExpression()->equal(e)) {
	tmp = true;
	break;
      }
    }

    if (tmp == false) {
      for (auto x : s->getExpression()->differentVars()) {
	Var* deo = new Var(x);
	tmp = false;
	for (auto i : _crts) {
	  auto e = i.first;
	  if (deo->equal(e)) {
	    tmp = true;
	    break;
	  }
	}
	if (tmp == false)
	  return false;
      }
    }
    
    if (tmp == false)
      return false;
  }
  return true;
}

extern map<string, QEx*> views;
extern void yyerror(string s);
void Query::preproccess(map<string, vector<string> > table_columns, vector<vector<set<string> > > table_keys_v) {

  for (auto f : _froms)
    if (views.count(f))
      _where = new And(_where, ((Query*)views[f])->_where);
  
  vector<string> froms;
  for (auto f : _froms)
    if (views.count(f))
      for (auto ff : views[f]->vectables())
	froms.push_back(ff);
    else
      froms.push_back(f);
  sort(froms.begin(), froms.end());

  map<string, string> aliases1;
  for (auto a : _aliases1) {
    if (views.count(a.first)) {
      for (auto ff : views[a.first]->vectables())
	aliases1[ff] = a.second + ((Query*)views[a.first])->_aliases1[ff];
    }
    else
      aliases1[a.first] = a.second;
  }
  _aliases1 = aliases1;
  
  if (_selections.size() == 0) {
    for (auto t : froms) {
      for (auto c : table_columns[t]) {
	_selections.push_back(new Selection(new Var(c), ""));
      }
    }
  }

  for (unsigned i = 0; i < _selections.size(); i++)
    if (_selections[i]->getName() == "")
      _selections[i]->setName("column_" + to_string(i));

  for (auto v : views) {
    for (auto s : ((Query*)v.second)->_selections)
      for (unsigned i = 0; i < _selections.size(); i++) {
	_selections[i]->setExpression(_selections[i]->getExpression()->substitute(s->getName(), s->getExpression()));
      }
  }

  /*
  map<string, string> cs;
  for (unsigned i = 0; i < _selections.size(); i++)
    cout  << _selections[i]->getExpression()->toFormula(cs, true) << endl;
  */
  
  if (_intos.size() != 0)
    if (_selections.size() != _intos.size())
      yyerror(string("Dimenzije u select-u (") + std::to_string(_selections.size()) + ") i into (" + std::to_string(_intos.size()) + ") moraju da se poklapaju");

  _froms = froms;

  //preprocesiranje order by klauze
  for (auto &p : _crts)
    if (p.second == false) {
      p.second = true;
      p.first = new Mul(new Num(-1), p.first);
    }
  //TODO: odsecanje order by izraza posle dostignutog primarnog kljuca
  
  return;
}

string Query::lav_position(bool la, int rank) const {
  string result;
  
  result += "(assert (forall ((r Red))";
  result += "(= ";
  
  string table = froms2table(_froms);
  string ttt = _where->lav_exists(table, rank, la);
  for (auto a : _where->differentInputs())
    ttt = regex_replace(ttt, regex(inputVar2var(a)), add_rank(inputVar2var(a), rank));
  result += ttt;
  result += "(exists ((p ";
  if (la == false)
    result += "(_  BitVec 32)";
  else
    result += "Int";
  result += "))";
  result += "(and ";
  if (la == false)
    result += "(bvsge p #x00000000) ";
  else
    result += "(>= p 0) ";
  result += "(= (rank" + to_string(_id) + " r t_res_" + to_string(_id) + ") p))";
  result += ")";
  result += ")))\n";

  return result;
}

string Query::positionInjectivness(bool la) const {
  string result;
  
  result += "(assert (forall ((r1 Red)(r2 Red)) ";
  result += "(=> ";
  result += "(exists ((p ";
  if (la == false)
    result += "(_  BitVec 32)";
  else
    result += "Int";
  result += "))";
  result += "(and ";
  if (la == false)
    result += "(bvsge p #x00000000) ";
  else
    result += "(>= p 0) ";
  result += "(= (rank" + to_string(_id) + " r1 t_res_" + to_string(_id) + ") p) ";
  result += "(= (rank" + to_string(_id) + " r2 t_res_" + to_string(_id) + ") p)";
  result += "))";
  result += "(= r1 r2)";
  result += ")))";

  return result;
}

string Query::detOrderBy(bool la) const {
  string result = "(=> (and ";
  string table_tmp = froms2table(vectables());
  regex reg(" r");
  result += regex_replace(getWhere()->lav_exists(table_tmp, -1, la), reg, " r1");
  result += regex_replace(getWhere()->lav_exists(table_tmp, -1, la), reg, " r2");
  result += ")";
  result += "(=> ";
  result += "(and ";
  vector<pair<Expression*, bool> > crts1 = getOrderBy();
  for (unsigned jj = 0; jj < crts1.size(); jj++) {
    result += "(= " + regex_replace(crts1[jj].first->lav_exists(table_tmp, -1, la), reg, " r1") + regex_replace(crts1[jj].first->lav_exists(table_tmp, -1, la), reg, " r2") + ")";
  }
  result += ")";
  result += "(and ";
  vector<Selection*> sels1 = getSelections();
  for (unsigned jj = 0; jj < sels1.size(); jj++) {
    result += "(= " + regex_replace(sels1[jj]->getExpression()->lav_exists(table_tmp, -1, la), reg, " r1") + regex_replace(sels1[jj]->getExpression()->lav_exists(table_tmp, -1, la), reg, " r2") + ")";
  }
  result += ")";
  result += "))";
  return result;
}

#include <fstream>
extern vector<QEx*> queries;
void writeCommon(ofstream &out1, set<string> tables, int max_rank, bool la, set<string> functions, set<string> uninterpreted_functions, set<string> variables_in) {
  out1 << generateCommon(tables, max_rank) << endl;
  out1 << generateFunctions(functions, la, max_rank) << endl;

  for (auto f : uninterpreted_functions) {
    if (f == "max" || f == "min" || f == "avg" || f == "sum" || f == "count") {
      if (la) {
	out1 << "(declare-fun " << f << " (Int Int) Int)" << endl;
      }
      else {
	out1 << "(declare-fun " << f << " ((_ BitVec 32)(_ BitVec 32)) (_ BitVec 32))" << endl;
      }
    }
    else {
      if (la)
	out1 << "(declare-fun " << f << " (Int) Int)" << endl;
      else
	out1 << "(declare-fun " << f << " ((_ BitVec 32)) (_ BitVec 32))" << endl;
    }
  }
  out1 << endl;

  if (la == false) {
    for (unsigned k = 0; k < queries.size(); k++)
      out1 << "(declare-const groupby_" << k << " (_ BitVec 32))" << endl;
    for (unsigned yy = 0; yy < AggFunction::getTotal(); yy++)
      out1 << "(declare-const fresh_new_" + to_string(yy) + " (_ BitVec 32))" << endl;
  }
  else {
    for (unsigned k = 0; k < queries.size(); k++)
      out1 << "(declare-const groupby_" << k << " Int)" << endl;
    for (unsigned yy = 0; yy < AggFunction::getTotal(); yy++)
      out1 << "(declare-const fresh_new_" + to_string(yy) + " Int)" << endl;
  }
  out1 << endl;
  
  for (auto v : variables_in) {
    if (la == false)
      out1 << "(declare-const " + v + " (_ BitVec 32))" << endl;
    else
      out1 << "(declare-const " + v + " Int)" << endl;
  }
  out1 << endl;
  return;
}
