#!/usr/bin/python
import sys
import re
import os
import time

total_start_time = time.time()

def print_stats(total_duration, eq):
    print 'stats:\t' + sys.argv[2] + '\t',
    if not cursors:
        print ' \t'*8, str(hlbC) + '\t' + str(eq) + '\t',
        print '{0:.3f}'.format(total_duration-hlbC_duration) + ' \t'*7,
        print '{0:.3f}'.format(hlbC_duration) + '\t' + '{0:.3f}'.format(total_duration) + '\t'
    else:
        print str(jeqC) + '\t' + str(feqC) + '\t' + str(detC1) + '\t' + str(detC2) + '\t' + str(oeqC) + '\t' + str(leqC) + '\t' + str(geqC) + '\t' + str(seqC) + '\t' + str(hlbC) + '\t' + str(eq) + '\t',
        print '{0:.3f}'.format(total_duration-feqC_duration-detC1_duration-detC2_duration-oeqC_duration-geqC_duration-seqC_duration-hlbC_duration) + '\t',
        print '{0:.3f}'.format(feqC_duration) if feqC_duration != 0 else ' ',
        print '\t',
        print '{0:.3f}'.format(detC1_duration) if detC1_duration != 0 else ' ',
        print '\t',
        print '{0:.3f}'.format(detC2_duration) if detC2_duration != 0 else ' ',
        print '\t',
        print '{0:.3f}'.format(oeqC_duration) if oeqC_duration != 0 else ' ',
        print '\t',
        print '{0:.3f}'.format(geqC_duration) if geqC_duration != 0 else ' ',
        print '\t',
        print '{0:.3f}'.format(seqC_duration) if seqC_duration != 0 else ' ',
        print '\t',
        print '{0:.3f}'.format(hlbC_duration) if hlbC_duration != 0 else ' ',
        print '\t',
        print '{0:.3f}'.format(total_duration) + '\t'


def exit1(eq):
    total_duration = time.time() - total_start_time
    print_stats(total_duration, eq)
    print 'TOTAL_TIME: %.3fs' % (total_duration)
    print
    print
    exit()

def str_la(x, la):
    if la:
        return str(x)
    else:
        return '#x' + format(x, '08x')

def list_to_str(x, separator):
    res = ''
    for y in range(len(x)):
        res += x[y]
        if y != len(x) - 1:
            res += separator
    return res

def success_id(m):
    success_id.counter += 1
    return "!success_" + chr(ord('a') + success_id.counter)
success_id.counter = -1

def non_interpret_function(m):
    indent = m.group(1)
    non_interpret_function.counter += 1
    filename = sql_filename + '.tmp' + chr(ord('a') + non_interpret_function.counter)
    try:
        f = open(filename, "r")
        lines = f.readlines()
        f.close()
        lines = map(lambda x: indent + x, lines)
        mm = re.search(r'sqc(\d)_[a-z]', lines[1])
        f_name = mm.group()
        num_args = int(mm.group(1))
        bracket = re.findall(r'[(][^)]+[)]', lines[0])[0]
        l = re.findall(r'\w_\w_\w+_sqc', bracket)
        for xx in range(len(l)):
            non_interpret_function.input_variables[l[xx]] = (f_name, xx + num_args - len(l) + 1)
        for iii in range(1, len(lines)):
            non_interpret_function.output_variables[re.findall(r'(\w_\w_\w+) = ', lines[iii])[0]] = (f_name, num_args, iii - 1, l)
        lines = map(lambda x: re.sub('([a-zA-Z]_)[a-zA-Z]_(\w+_sqc)', r'\1\2', x), lines)
        return list_to_str(lines, '')
    except IOError:
        exit("Greska pri otvaranju privremenih fajlova")
non_interpret_function.counter = -1
non_interpret_function.input_variables = {}
non_interpret_function.output_variables = {}

def change_names(x, y, z):
    if z != '':
        z = '_' + z
    return re.sub('(\w+_sqc)', y + z + r'_\1', x)

def add_rank(v, rank):
    return re.sub('_sqc', '_' + str(rank) + '_sqc', v)

def read_result(fname):
    try:
        fff = open(fname, "r")
        res = fff.read()
        fff.close()
        return res
    except IOError:
        exit("Greska pri otvaranju fajla " + fname)


def solve(filename, t, printing = True):
    if printing: print '-------------------------------------------------'
    if printing: print t, "equivalence condition:"
    
    vampire_res = ""
    z3_res = ""
    if (sys.argv[1] == '--vampire'):
        if printing: print 'Vampire:'
        pattern_status = '% Termination reason: (.*)'
        command = r"vampire --input_syntax smtlib2 " + filename + r" | egrep '" + pattern_status + r"' | sed -r 's/" + pattern_status + r"/\1/'" + " > output"
        start_time = time.time()
        os.system(command)
        vampire_res = read_result("output").strip()
        if printing: print vampire_res
        duration = time.time() - start_time
        if printing: print t, '%.3fs' % (duration)
    else:
        if printing: print 'Z3:'
        command = 'z3 -T:60 -smt2 ' + filename + " > output"
        #command = 'z3 -smt2 ' + filename + " > output"
        start_time = time.time()
        os.system(command)
        z3_res = read_result("output").strip()
        if printing: print z3_res
        duration = time.time() - start_time
        if printing: print t, 'time: %.3fs' % (duration)
        
    if printing: print '-------------------------------------------------'

    os.system("rm output")
    if vampire_res == "" and (z3_res == "" or z3_res == "unknown"):
        return ('ERR', duration)
    if vampire_res == "Time limit" or vampire_res.startswith("Refutation not found") or z3_res == "timeout":
        print vampire_res
        return ('TO', duration)
    if vampire_res == "Refutation" or z3_res == "unsat":
        return (True, duration)
    return (False, duration)

def first_line(fname):
    try:
        fff = open(fname, "r")
        res = fff.readline()
        fff.close()
        return res
    except IOError:
        exit("Greska pri otvaranju fajla " + fname)
    
if len(sys.argv) < 3:
    print "koriscenje:", sys.argv[0], "(--z3|--vampire) file.sqc", "[--la] [--cursors num]"
    exit()

if sys.argv[1] != '--z3' and sys.argv[1] != '--vampire':
    print 'First argument must be --z3 or --vampire'
    exit()
    
if re.match(".*\.sqc", sys.argv[2], re.I) == None:
    print "Datoteka mora biti sqc"
    exit()

if '--la' in sys.argv:
    la = True
else:
    la = False

sql_filename = re.sub('[.]sqc$', '.sql', sys.argv[2])
c_filename = re.sub('[.]sqc$', '.c', sys.argv[2])
smt_filename = re.sub('[.]sqc$', '.smt', sys.argv[2])
jeqc_smt_filename = re.sub('[.]smt$', '.jeqc.smt', smt_filename)
feqc_smt_filename = re.sub('[.]smt$', '.feqc.smt', smt_filename)
geqc_smt_filename = re.sub('[.]smt$', '.geqc.smt', smt_filename)
seqc_smt_filename = re.sub('[.]smt$', '.seqc.smt', smt_filename)
#deqc_smt_filename = re.sub('[.]smt$', '.deqc.smt', smt_filename)
detc1_smt_filename = re.sub('[.]smt$', '.detc1.smt', smt_filename)
detc2_smt_filename = re.sub('[.]smt$', '.detc2.smt', smt_filename)
oeqc_smt_filename = re.sub('[.]smt$', '.oeqc.smt', smt_filename)
pk_in_ob_filename = re.sub('[.]smt$', '.tmp.primary_key_in_orderby', smt_filename)
leqc_smt_filename = re.sub('[.]smt$', '.leqc.smt', smt_filename)
agg_smt_filename = re.sub('[.]smt$', '.agg_\d+_\d+.smt', os.path.basename(smt_filename))

try:
    f = open(sys.argv[2], "r")
    content = f.read()
    f.close()
    g1 = open(sql_filename, 'w')
    g2 = open(c_filename, 'w')
except IOError:
    exit("Greska pri otvaranju fajla " + sys.argv[2])

queries = []
views = []
views_name = []

pattern_exec_sql_select_into = r"([\t ]*)EXEC\s+SQL\s+(SELECT[^;]+;)([ \t]*\n)?"
pattern_exec_sql_create_view = r"([\t ]*)EXEC\s+SQL\s+(CREATE\s+VIEW\s+(\w+)\s+AS\s+)(SELECT[^;]+;)([ \t]*\n)?"
for x in re.finditer(pattern_exec_sql_select_into, content, re.I):
    query = x.group(2)
    query = re.sub('[ \t]+', ' ', query).strip()
    query = re.sub('^\s+', "", query, flags=re.M)
    queries.append(query)
for x in re.finditer(pattern_exec_sql_create_view, content, re.I):
    query = x.group(2) + x.group(4)
    query = re.sub('[ \t]+', ' ', query).strip()
    query = re.sub('^\s+', "", query, flags=re.M)
    views.append(query)
    views_name.append(x.group(3))

cursors = False
content_curr = content
pattern_exec_sql_declare = r"([\t ]*)EXEC\s+SQL\s+DECLARE\s+(\w+)\s+CURSOR\s+FOR([^;]+;)([ \t]*\n)?"
pattern_exec_sql_fetch   = r"([\t ]*)EXEC\s+SQL\s+FETCH\s+\w+\s+INTO([^;]+);"
pattern_group_by   = r"GROUP BY"
while True:
    x = re.search(pattern_exec_sql_declare, content_curr, re.I)
    if x is None:
        break
    cursors = True
    query = x.group(3)
    query = re.sub('[ \t]+', ' ', query).strip()
    query = re.sub('^\s+', "", query, flags=re.M)
    content_curr = content_curr[x.end():]
    y = re.search(pattern_exec_sql_fetch, content_curr, re.I)
    query = re.sub('\nFROM',  ' INTO ' + y.group(2) + '\nFROM', query, flags = re.I)
    queries.append(query)

max_rank = 0
if cursors:
    if '--cursors' not in sys.argv:
        exit("Missing '--cursors num' argument")
    cc = sys.argv.index('--cursors')
    max_rank = int(sys.argv[cc + 1])
else:
    if '--cursors' in sys.argv:
        print "Argument '--cursors num' ignored"
        cc = sys.argv.index('--cursors')
        sys.argv.pop(cc)
        sys.argv.pop(cc)

type = r"int[*]?"
args = type + r"\s+[*]*[a-zA-Z_]\w*" + r"(\s*[,]\s+" + type + r"\s+[*]*[a-zA-Z_]\w*)*"
function_pattern  = r"^" + '(' + type + '|void)' + r"\s+" + r"([a-z])" + r"\s*[(](" + args + r")\s*[)]\s*[{]\s*"
function_pattern += r"(\n|.)*?^[}]"

f_args_queries = []
f_arrays = []
for x in re.finditer(function_pattern, content, re.M):
    function_str = x.group()
    q_no = len(re.findall(pattern_exec_sql_select_into, function_str))
    if q_no == 0:
        q_no = len(re.findall(pattern_exec_sql_fetch, function_str))
        if q_no != 1:
            exit('Broj kursora po fji mora biti 1')
    args_no = len(re.findall(',', x.group(3))) + 1 - len(re.findall('[*]+', x.group(3)))
    f_arrays.append((x.group(2), len(re.findall('[*]+', x.group(3)))))
    f_args_queries.append((x.group(2), args_no, q_no))

if len(f_args_queries) != 2:
    print f_args_queries
    exit('Potrebno je imati tacno dve funckije cija se ekvivalentnost dokazuje')

numberofargs = f_args_queries[0][1]
if f_args_queries[0][1] != f_args_queries[1][1]:
    exit('Broj argumenata funkcija mora da bude isti')

for i in range(0, f_args_queries[0][2]):
    queries[i] = change_names(queries[i], f_args_queries[0][0], chr(ord('a') + i))
for i in range(f_args_queries[0][2], f_args_queries[0][2] + f_args_queries[1][2]):
    queries[i] = change_names(queries[i], f_args_queries[1][0], chr(ord('a') + i))
for j in range(0, len(views)):
    i = 0
    while True:
        if views_name[j] in queries[i]:
            break
        i = i + 1
    if i < f_args_queries[0][2]:
        ttt = f_args_queries[0][0]
    else:
        ttt = f_args_queries[1][0]
    views[j] = change_names(views[j], ttt, chr(ord('a') + i))
    g1.write(views[j] + '\n\n')
for q in queries:
    g1.write(q + '\n\n')
g1.close()

#try_deqC = False
#number_of_distinct = 0
#for q in queries:
#    if "distinct" in q.lower():
#        number_of_distinct += 1
#if cursors and number_of_distinct == 2:
#    try_deqC = True

os.system('./sql2theory --lav ' + sql_filename + ' ' + list_to_str(sys.argv[3:], ' '))
print     './sql2theory --lav ' + sql_filename + ' ' + list_to_str(sys.argv[3:], ' ')

if re.search('[!]sqlca[.]sqlcode', content) == None:
    try_success = True
else:
    try_success = False

sqc_variables = set()
function_strs = []
function_strs_orig = []
for x in re.finditer(function_pattern, content, re.M):
    function_str = x.group()
    function_strs_orig.append(function_str)
    function_str = change_names(function_str, x.group(2), '')
    function_str = re.sub('sqlca[.]sqlcode', success_id, function_str)
    
    #SELECT INTO
    function_str = re.sub(pattern_exec_sql_select_into, non_interpret_function, function_str)
    
    #CURSORS
    function_str = re.sub(pattern_exec_sql_declare, '', function_str)
    function_str = re.sub('CHECK_SQL[^;]+;\s+', '', function_str)
    function_str = re.sub('EXEC\s+SQL\s+OPEN[^;]+;\s+', '', function_str)
    function_str = re.sub('EXEC\s+SQL\s+CLOSE[^;]+;\s+', '', function_str)
    function_str = re.sub(pattern_exec_sql_fetch, non_interpret_function, function_str)
    function_str = re.sub(pattern_exec_sql_create_view, '', function_str)

    #TODO: Ovo je takodje hardkodirano
    if cursors:
        function_str = re.sub(r'(success_[a-z])([^[])', r'\1[i]\2', function_str)
        function_str = re.sub('while\s+\(i\s*<\s*[0-9]+\)', 'while (i < ' + str(max_rank+1) + ')', function_str)
    
    sqc_variables = sqc_variables.union(set(re.findall('\w_\w+_sqc', function_str)))
    function_strs.append(function_str)

try_geqC = False
yy0 = re.search(pattern_group_by, function_strs_orig[0])
yy1 = re.search(pattern_group_by, function_strs_orig[1])
if cursors and (yy0 is not None or yy1 is not None):
    try_geqC = True
    
try_seqC = False
y0 = re.search(pattern_exec_sql_fetch, function_strs_orig[0])
y1 = re.search(pattern_exec_sql_fetch, function_strs_orig[1])
if cursors and y0 is not None and y1 is not None:
    rest0 = function_strs_orig[0][y0.start():].replace("c1", "c")
    rest1 = function_strs_orig[1][y1.start():].replace("c2", "c")
    if rest0 == rest1:
        try_seqC = True

add_eqs = False
y0 = re.search(pattern_exec_sql_declare, function_strs_orig[0])
y1 = re.search(pattern_exec_sql_declare, function_strs_orig[1])
if cursors and y0 is not None and y1 is not None:
    beg0 = re.sub(r'.+\n', '', function_strs_orig[0][:y0.start()], 1)
    beg1 = re.sub(r'.+\n', '', function_strs_orig[1][:y1.start()], 1)
    if beg0 == beg1:
        add_eqs = True
    
g2.write('int assert_lav(int);\n')
try:
    f = open(sql_filename + '.tmp', "r")
    g2.write(f.read() + '\n')
    f.close()
except IOError:
    exit("Greska pri otvaranju privremenog fajla")
    
for x in sqc_variables:
    g2.write('int '+ x+';\n')

for x in function_strs:
    g2.write('\n' + x + '\n')
g2.write('\n')

g2.write('int main() {\n')

arguments = []
for i in range(numberofargs):
    arguments.append('sqc_' + chr(ord('a') + i))
for a in arguments:
    g2.write('\tint ' + a + ';\n')
if cursors:
    for ff, number_of_arrays in f_arrays:
        for ii in range(number_of_arrays):
            g2.write('\tint niz_' + ff + '_' + str(ii) + '[' + str((max_rank+2, max_rank+1)[max_rank!=0]) + '];\n')

for f in range(len(f_args_queries)):
    if not cursors:
        g2.write('\tint ' + f_args_queries[f][0] + '_result = ' + f_args_queries[f][0] + '(')
    else:
        g2.write('\t' + f_args_queries[f][0] + '(')
    if len(arguments) != 0:
        g2.write(arguments[0])
    for a in arguments[1:]:
        g2.write(', ' + a)
    if cursors:
        for j in range(f_arrays[f][1]):
            if j != 0 or len(arguments) > 0:
                g2.write(', ')
            g2.write('niz_' + f_args_queries[f][0] + '_' + str(j))
    g2.write(')' + ';\n')

if not cursors:
    g2.write('\tassert_lav(')

    if try_success:
        g2.write('(')
        if f_args_queries[0][2] == 1:
            g2.write('success_' + chr(ord('a')))
        else:
            g2.write('(success_' + chr(ord('a')))
            for j in range(1, f_args_queries[0][2]):
                g2.write(' && success_' + chr(ord('a') + j))
            g2.write(')')
        g2.write(' == ')
        if f_args_queries[1][2] == 1:
            g2.write('success_' + chr(ord('a') + f_args_queries[0][2]))
        else:
            g2.write('(success_' + chr(ord('a') + f_args_queries[0][2]))
            for j in range(1, f_args_queries[1][2]):
                g2.write(' && success_' + chr(ord('a') + f_args_queries[0][2] + j))
            g2.write(')')
        g2.write(') && ')

    
    g2.write('(' + f_args_queries[0][0] + '_result == ' + f_args_queries[1][0] + '_result' + '));\n')
#    g2.write('\tassert_lav(' + f_args_queries[0][0] + '_result == ' + f_args_queries[1][0] + '_result' + ');\n')
else:
    g2.write('\tassert_lav(\n')
    for i in range(max_rank + 1):
        if i != 0:
            g2.write('\t\t     && ')
        else:
            g2.write('\t\t\t')
        g2.write('(success_a[' + str(i) + '] == success_b[' + str(i) + ']) && (')
        for j in range(f_arrays[0][1]):
            if j != 0:
                g2.write(' && ')
            g2.write('(niz_' + f_arrays[0][0] + '_' + str(j) + '[' + str(i) + '] == niz_' + f_arrays[1][0] + '_' + str(j) + '[' + str(i) + '])')
        g2.write(')\n')
    g2.write('\t);\n')

g2.write('\treturn 0;\n')
g2.write('}\n')   
g2.close()

lav_start_time = time.time()
print     "./prevediIPokreniFajl.sh " + re.sub('\.c$', '', c_filename) + " " + str(max_rank+1) + " " + ("LA", "BV")[la!=True]
os.system("./prevediIPokreniFajl.sh " + re.sub('\.c$', '', c_filename) + " " + str(max_rank+1) + " " + ("LA", "BV")[la!=True])
print 'LAV_TIME: %.3fs' % (time.time() - lav_start_time)

try:
    #FOLc
    f1 = open(smt_filename + '1', "r")
    content1 = f1.read()
    f1.close()

    #FOLsql
    f2 = open(smt_filename + '2', "r")
    content2 = f2.read()
    f2.close()

    if cursors:
        # filter condition
        f3 = open(smt_filename + '3', "r")
        content3 = f3.read()
        f3.close()
        # groupby condition
        f7 = open(smt_filename + '7', "r")
        content7 = f7.read()
        f7.close()
        # select condition
        f4 = open(smt_filename + '4', "r")
        content4 = f4.read()
        f4.close()
        # det-ordering condition 1
        f51 = open(smt_filename + '51', "r")
        content51 = f51.read()
        f51.close()
        # det-ordering condition 2
        f52 = open(smt_filename + '52', "r")
        content52 = f52.read()
        f52.close()
        # order condition
        f6 = open(smt_filename + '6', "r")
        content6 = f6.read()
        f6.close()
        content2 += '(assert (= t_res_0 t_res_1))\n\n'

    g1 = open(smt_filename, 'w')
    if cursors:
        g2 = open(feqc_smt_filename, 'w')
        g7 = open(geqc_smt_filename, 'w')
        g3 = open(seqc_smt_filename, 'w')
        g41= open(detc1_smt_filename, 'w')
        g42= open(detc2_smt_filename, 'w')
        g5 = open(oeqc_smt_filename, 'w')

    #print 'Inputs:', non_interpret_function.input_variables
    #print 'Outputs:', non_interpret_function.output_variables
    
    assign = {}
    assign_tmp = {}
    
    if not cursors:
        for v, k in non_interpret_function.input_variables.iteritems():
            patt = '\(\s*' + k[0] + '(\s+((\w|[#])+|\([^)]+?\))){' + str(k[1] - 1) + '}\s+((\w|[#])+|\([^)]+?\))'
            m = re.search(patt, content1)
            if m is None:
                print 'Cannot assign variable ', v
                #print patt
                variable = 'MISSING_VALUE'
            else:
                variable = m.group(4)
                #print v, ' - ', variable
            assign[v] = variable
        for v, k in non_interpret_function.output_variables.iteritems():
            variable = '(' + k[0] + ' ' + str_la(k[2], la) + ' ' + list_to_str(map(lambda x: assign[x], k[3]), ' ') + ')'
            #print v, ' - ', variable
            assign[v] = variable
            
#            patt = '\(\s*=\s*\(\s*' + k[0] + '\s+' + str(k[2]) + '(\s+(\w+|\([^)]+?\))){' + str(k[1]-1) + '}\s*\)\s*(\w+)\)'
#            m = re.search(patt, content1)
#            if m is None:
#                print 'Cannot assert variable ', v
#                #print patt
#                variable = 'MISSING_VALUE'
#            else:
#                variable = m.group(3)
#                #print v, ' - ', variable
#            assign[v] = variable
#            
    else:
        for rank in range(max_rank + 1):
            for v, k in non_interpret_function.input_variables.iteritems():
                patt = '\(\s*' + k[0] + '\s+' + str_la(rank, la) + '(\s+((\w|[#])+|\([^)]+?\))){' + str(k[1] - 2) + '}\s+((\w|[#])+|\([^)]+?\))'
                m = re.search(patt, content1)
                if m is None:
                    print 'Cannot assign variable ', v
                    #print patt
                    variable = 'MISSING_VALUE'
                else:
                    variable = m.group(4)
                    #print v, ' - ', variable
                assign_tmp[v] = variable
                v = add_rank(v, rank)
                assign[v] = variable
            for v, k in non_interpret_function.output_variables.iteritems():
                variable = '(' + k[0] + ' ' + str_la(rank, la) + ' ' + str_la(k[2], la) + ' ' + list_to_str(map(lambda x: assign[add_rank(x, rank)], k[3]), ' ') + ')'
                v = add_rank(v, rank)
                #print v, ' - ', variable
                assign[v] = variable

    links1 = ''
    for v, variable in assign.iteritems():
        links1 += '(assert (= _' + v + ' ' + variable + '))\n'

    links2 = ''
    for v, variable in assign_tmp.iteritems():
        links2  += '(assert (= _' + v + ' ' + variable + '))\n'

    equalities1 = ''
    done1 = set()
    equalities2 = ''
    done2 = set()
    if add_eqs:
        for in_var in non_interpret_function.input_variables:
            in_var_common = in_var[3:]
            if in_var_common in done1:
                continue
            done1.add(in_var_common)
            for rank in range(max_rank + 1):
                in_var_common_rank = add_rank(in_var_common, rank)
                equalities1  += '(assert (= _' + f_args_queries[0][0] + '_a' + in_var_common_rank + ' _' + f_args_queries[1][0] + '_b' + in_var_common_rank + '))\n'
        
        for in_var in non_interpret_function.input_variables:
            in_var_common = in_var[3:]
            if in_var_common in done2:
                continue
            done2.add(in_var_common)
            equalities2  += '(assert (= _' + f_args_queries[0][0] + '_a' + in_var_common + ' _' + f_args_queries[1][0] + '_b' + in_var_common + '))\n'
        
    if la:
        for x in ['add', 'sub', 'mul', 'sdiv']:
            if x in content2 and x not in content1:
                g1.write("(declare-fun " + x + " (Int Int) Int)\n")
	g1.write("\n")
            
    #hlbC
    number_of_qs = 0
    for i in range(0, len(f_args_queries)):
        number_of_qs += f_args_queries[i][2]
    groupby_eqs = "(assert (= groupby_0 groupby_1))\n"
    for i in range(2, number_of_qs):
        groupby_eqs += "(assert (= groupby_0 groupby_" + str(i) + "))\n"
    g1.write(re.sub(';MIRKO.SMT', content2 + links1 + equalities1 + groupby_eqs, content1))
    g1.close()

    if cursors:
        #filter condition
        content11 = content1[:content1.rfind(';MIRKO.SMT')]
        content11 = content11[:content11.rfind('(assert')]
        g2.write(content11)
        g2.write(content3)
        g2.write(links2)
        g2.write(equalities2)
        g2.write('\n(check-sat)\n')
        g2.close()

        # group by condition
        g7.write(content11)
        g7.write(content7)
        g7.write(links2)
        g7.write(equalities2)
        g7.write('\n(check-sat)\n')
        g7.close()
        
        # select condition
        g3.write(content11)
        g3.write(content4)
        g3.write(links2)
        g3.write(equalities2)
        g3.write('(assert (= groupby_0 groupby_1))')
        g3.write('\n(check-sat)\n')
        g3.close()

        # det-ordering condition 1
        g41.write(content11)
        g41.write(content51)
        g41.write('(assert (= groupby_0 groupby_1))')
        g41.write('\n(check-sat)\n')
        g41.close()

        # det-ordering condition 2
        g42.write(content11)
        g42.write(content52)
        g42.write('(assert (= groupby_0 groupby_1))')
        g42.write('\n(check-sat)\n')
        g42.close()

        # order condition
        g5.write(content11)
        g5.write(content6)
        g5.write('(assert (= groupby_0 groupby_1))')
        g5.write('\n(check-sat)\n')
        g5.close()
except IOError:
    exit("Greska pri otvaranju fajlova sa formulama")

if cursors:
    try:
        ff = open(jeqc_smt_filename, "r")
        jeqC = ff.read()
        if jeqC.strip() == "True":
            jeqC = True
        else:
            jeqC = False
        ff.close()
    except IOError:
        exit("Greska pri otvaranju fajla " + jeqc_smt_filename)

    try:
        ff = open(pk_in_ob_filename, "r")
        pk = ff.read()
        if pk.strip() == "true":
                use_pos_eq = True
        else:
                use_pos_eq = False
        ff.close()
    except IOError:
        exit("Greska pri otvaranju fajla " + jeqc_smt_filename)

os.system('rm -f ' + sql_filename + ' ' + sql_filename+'.tmp* ' + c_filename + ' ' + smt_filename+'?*' + ' ' + pk_in_ob_filename)

#-----------------------------------------------
# Trying to solve the equivalence problem
#-----------------------------------------------

if not cursors:
    (hlbC, hlbC_duration) = solve(smt_filename, "Hlbc")
    print "hlbC =", hlbC,
    if hlbC:
        print "(total)"
    else:
        print
else:
    feqC = " "
    detC1 = " "
    detC2 = " "
    oeqC = " "
    leqC = " "
    geqC = " "
    seqC = " "
    hlbC = " "
    
    feqC_duration = 0
    detC1_duration = 0
    detC2_duration = 0
    #deqC_duration = 0
    oeqC_duration = 0
    geqC_duration = 0
    seqC_duration = 0
    hlbC_duration = 0
    
    print "jeqC =", jeqC
    if jeqC != True:
        exit1(jeqC)
        
    (feqC, feqC_duration) = solve(feqc_smt_filename, "Filter")
    print "feqC =", feqC
    if feqC != True:
        exit1(feqC)
        
    if try_geqC:
        (geqC, geqC_duration) = solve(geqc_smt_filename, "GroupBy")
        print "geqC =", geqC
        if geqC != True:
            exit1(geqC)

    #    if try_deqC:
    #        (deqC, deqC_duration) = solve(deqc_smt_filename, "Distinct")
    #    if try_deqC:
    #        print "deqC =", deqC
    #    if try_deqC and not deqC:
    #        exit1(False)

    fresh_new_eqs = ""
    dirname = os.path.dirname(smt_filename)
    for f in os.listdir(dirname):
        if re.match(agg_smt_filename, f) is None:
            continue
        (aggC, aggC_duration) = solve(dirname + "/" + f, "AggCond", False)
        if aggC == True:
             fresh_new_eqs += first_line(dirname + "/" + f)[1:-1] + "\\n"
    if fresh_new_eqs != "":
        os.system("sed -i 's/(assert (= groupby_0 groupby_1))/(assert (= groupby_0 groupby_1))\\n" + fresh_new_eqs + "/g' " + detc1_smt_filename)
        os.system("sed -i 's/(assert (= groupby_0 groupby_1))/(assert (= groupby_0 groupby_1))\\n" + fresh_new_eqs + "/g' " + detc2_smt_filename)
        os.system("sed -i 's/(assert (= groupby_0 groupby_1))/(assert (= groupby_0 groupby_1))\\n" + fresh_new_eqs + "/g' " + oeqc_smt_filename)
        os.system("sed -i 's/(assert (= groupby_0 groupby_1))/(assert (= groupby_0 groupby_1))\\n" + fresh_new_eqs + "/g' " + seqc_smt_filename)
        os.system("sed -i 's/(assert (= groupby_0 groupby_1))/(assert (= groupby_0 groupby_1))\\n" + fresh_new_eqs + "/g' " + smt_filename)
    
    
    (detC1, detC1_duration) = solve(detc1_smt_filename, "DetOrder")
    print "detC1 =", detC1
    if detC1 == False:
        print "Fix deterministic ordering in the first query!"
        use_pos_eq = True
    if detC1 == 'ERR' or detC1 == 'TO':
        exit1(detC1)

    (detC2, detC2_duration) = solve(detc2_smt_filename, "DetOrder")
    print "detC2 =", detC2
    if detC2 == False:
        print "Fix deterministic ordering in the second query!"
        use_pos_eq = True
    if detC2 == 'ERR' or detC2 == 'TO':
        exit1(detC2)
        
    (oeqC, oeqC_duration) = solve(oeqc_smt_filename, "Order")
    print "oeqC =", oeqC
    if oeqC == False:
        print "Fix orderings!"
    if oeqC== 'ERR' or oeqC == 'TO':
        exit1(oeqC)

    try:
        ff = open(leqc_smt_filename, "r")
        limit_a = int(ff.readline())
        limit_b = int(ff.readline())
        if limit_a == limit_b:
            leqC = True
        else:
            leqC = False
        ff.close()
    except IOError:
        exit("Greska pri otvaranju fajla " + jeqc_smt_filename)
    print "leqC =", leqC
    if not leqC:
        print "Fix limits!"

    if try_seqC:
        (seqC, seqC_duration) = solve(seqc_smt_filename, "Select")
        print "seqC =", seqC,
        if seqC == True:
            print "(total)"
        else:
            print
        exit1(seqC)

    if use_pos_eq:
        os.system("sed -i 's/(declare-fun rank1 (Red TRes) Int)//g' " + smt_filename)
        os.system("sed -i 's/rank1/rank0/g' " + smt_filename)
        
    (hlbC, hlbC_duration) = solve(smt_filename, "Hlbc")
    print "hlbC =", hlbC,
    if hlbC == True:
        if limit_a < 0 or max_rank + 1 < limit_a:
            print "(" + str(max_rank+1) + "-equivalent)"
        else:
            print "(total)"
    else:
        print

exit1(hlbC)



